/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Membership;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.protocols.pbcast.Digest;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.GmsImpl;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.protocols.pbcast.MergeData;
import org.jgroups.util.TimeScheduler;

public class CoordGmsImpl
extends GmsImpl {
    private boolean merging = false;
    private final MergeTask merge_task = new MergeTask();
    private final Vector merge_rsps = new Vector(11);
    private Serializable merge_id = null;
    private Address merge_leader = null;
    private MergeCanceller merge_canceller = null;

    public CoordGmsImpl(GMS g) {
        this.gms = g;
    }

    void setMergeId(Serializable merge_id) {
        this.merge_id = merge_id;
        if (this.merge_id != null) {
            this.stopMergeCanceller();
            this.merge_canceller = new MergeCanceller(this.merge_id, this.gms.merge_timeout);
            this.gms.timer.add(this.merge_canceller);
        } else {
            this.stopMergeCanceller();
        }
    }

    private void stopMergeCanceller() {
        if (this.merge_canceller != null) {
            this.merge_canceller.cancel();
            this.merge_canceller = null;
        }
    }

    public void init() throws Exception {
        super.init();
        this.cancelMerge();
    }

    public void join(Address mbr) {
        this.wrongMethod("join");
    }

    public void leave(Address mbr) {
        if (mbr == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"member's address is null !");
            }
            return;
        }
        if (mbr.equals(this.gms.local_addr)) {
            this.leaving = true;
        }
        this.handleLeave(mbr, false);
    }

    public void handleJoinResponse(JoinRsp join_rsp) {
        this.wrongMethod("handleJoinResponse");
    }

    public void handleLeaveResponse() {
    }

    public void suspect(Address mbr) {
        this.handleSuspect(mbr);
    }

    public void unsuspect(Address mbr) {
    }

    public void merge(Vector other_coords) {
        if (this.merging) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)"merge already in progress, discarded MERGE event");
            }
            return;
        }
        this.merge_leader = null;
        if (other_coords == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)"list of other coordinators is null. Will not start merge.");
            }
            return;
        }
        if (other_coords.size() <= 1) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("number of coordinators found is " + other_coords.size() + "; will not perform merge"));
            }
            return;
        }
        Membership tmp = new Membership(other_coords);
        tmp.sort();
        this.merge_leader = (Address)tmp.elementAt(0);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("coordinators in merge protocol are: " + tmp));
        }
        if (this.merge_leader.equals(this.gms.local_addr) || this.gms.merge_leader) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("I (" + this.gms.local_addr + ", merge_leader=" + this.gms.merge_leader + ") will be the leader. Starting the merge task"));
            }
            this.startMergeTask(other_coords);
        } else if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("I (" + this.gms.local_addr + ") am not the merge leader (" + this.merge_leader + "), waiting for merge leader to initiate merge"));
        }
    }

    public void handleMergeRequest(Address sender, Object merge_id) {
        if (sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"sender == null; cannot send back a response");
            }
            return;
        }
        if (this.merging) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"merge already in progress");
            }
            this.sendMergeRejectedResponse(sender);
            return;
        }
        this.merging = true;
        this.setMergeId((Serializable)merge_id);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("sender=" + sender + ", merge_id=" + merge_id));
        }
        Digest digest = this.gms.getDigest();
        View view = new View(this.gms.view_id.copy(), this.gms.members.getMembers());
        this.sendMergeResponse(sender, view, digest);
    }

    MergeData getMergeResponse(Address sender, Object merge_id) {
        if (sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"sender == null; cannot send back a response");
            }
            return null;
        }
        if (this.merging) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"merge already in progress");
            }
            MergeData retval = new MergeData(sender, null, null);
            retval.merge_rejected = true;
            return retval;
        }
        this.merging = true;
        this.setMergeId((Serializable)merge_id);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("sender=" + sender + ", merge_id=" + merge_id));
        }
        Digest digest = this.gms.getDigest();
        View view = new View(this.gms.view_id.copy(), this.gms.members.getMembers());
        MergeData retval = new MergeData(sender, view, digest);
        retval.view = view;
        retval.digest = digest;
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMergeResponse(MergeData data, Object merge_id) {
        if (data == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"merge data is null");
            }
            return;
        }
        if (merge_id == null || this.merge_id == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("merge_id (" + merge_id + ") or this.merge_id (" + this.merge_id + ") == null (sender=" + data.getSender() + ")."));
            }
            return;
        }
        if (!this.merge_id.equals(merge_id)) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("this.merge_id (" + this.merge_id + ") is different from merge_id (" + merge_id + ')'));
            }
            return;
        }
        Vector vector = this.merge_rsps;
        synchronized (vector) {
            if (!this.merge_rsps.contains(data)) {
                this.merge_rsps.addElement(data);
                this.merge_rsps.notifyAll();
            }
        }
    }

    public void handleMergeView(MergeData data, Object merge_id) {
        if (merge_id == null || this.merge_id == null || !this.merge_id.equals(merge_id)) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"merge_ids don't match (or are null); merge view discarded");
            }
            return;
        }
        this.gms.castViewChange(data.view, data.digest);
        this.merging = false;
        merge_id = null;
    }

    public void handleMergeCancelled(Object merge_id) {
        if (merge_id != null && this.merge_id != null && this.merge_id.equals(merge_id)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("merge was cancelled (merge_id=" + merge_id + ')'));
            }
            this.setMergeId(null);
            this.merge_leader = null;
            this.merging = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelMerge() {
        if (this.merge_id != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("cancelling merge (merge_id=" + this.merge_id + ')'));
        }
        this.setMergeId(null);
        this.merge_leader = null;
        this.stopMergeTask();
        this.merging = false;
        Vector vector = this.merge_rsps;
        synchronized (vector) {
            this.merge_rsps.clear();
        }
    }

    public synchronized JoinRsp handleJoin(Address mbr) {
        Vector<Address> new_mbrs = new Vector<Address>(1);
        View v = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("mbr=" + mbr));
        }
        if (this.gms.local_addr.equals(mbr)) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"cannot join myself !");
            }
            return null;
        }
        if (this.gms.members.contains(mbr)) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("member " + mbr + " already present; returning existing view " + this.gms.members.getMembers()));
            }
            return new JoinRsp(new View(this.gms.view_id, this.gms.members.getMembers()), this.gms.getDigest());
        }
        new_mbrs.addElement(mbr);
        Digest tmp = this.gms.getDigest();
        if (tmp == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"received null digest from GET_DIGEST: will cause JOIN to fail");
            }
            return null;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("got digest=" + tmp));
        }
        Digest d = new Digest(tmp.size() + 1);
        d.add(tmp);
        d.add(mbr, 0L, 0L);
        v = this.gms.getNextView(new_mbrs, null, null);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("joined member " + mbr + ", view is " + v));
        }
        return new JoinRsp(v, d);
    }

    public synchronized void handleLeave(Address mbr, boolean suspected) {
        Vector<Address> v = new Vector<Address>(1);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("mbr=" + mbr));
        }
        if (!this.gms.members.contains(mbr)) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("mbr " + mbr + " is not a member !"));
            }
            return;
        }
        if (this.gms.view_id == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("gms.view_id is null, I'm not the coordinator anymore (leaving=" + this.leaving + "); the new coordinator will handle the leave request"));
            }
            return;
        }
        this.sendLeaveResponse(mbr);
        v.addElement(mbr);
        if (suspected) {
            this.gms.castViewChange(null, null, v);
        } else {
            this.gms.castViewChange(null, v, null);
        }
    }

    void sendLeaveResponse(Address mbr) {
        Message msg = new Message(mbr, null, null);
        GMS.GmsHeader hdr = new GMS.GmsHeader(4);
        msg.putHeader(this.gms.getName(), hdr);
        this.gms.passDown(new Event(1, msg));
    }

    public void handleViewChange(View new_view, Digest digest) {
        Vector mbrs = new_view.getMembers();
        if (this.log.isDebugEnabled()) {
            if (digest != null) {
                this.log.debug((Object)("view=" + new_view + ", digest=" + digest));
            } else {
                this.log.debug((Object)("view=" + new_view));
            }
        }
        if (this.leaving && !mbrs.contains(this.gms.local_addr)) {
            return;
        }
        this.gms.installView(new_view, digest);
    }

    public void handleSuspect(Address mbr) {
        if (mbr.equals(this.gms.local_addr)) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)"I am the coord and I'm being am suspected -- will probably leave shortly");
            }
            return;
        }
        this.handleLeave(mbr, true);
    }

    public void handleExit() {
        this.cancelMerge();
    }

    public void stop() {
        super.stop();
        this.stopMergeTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startMergeTask(Vector coords) {
        MergeTask mergeTask = this.merge_task;
        synchronized (mergeTask) {
            this.merge_task.start(coords);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopMergeTask() {
        MergeTask mergeTask = this.merge_task;
        synchronized (mergeTask) {
            this.merge_task.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getMergeDataFromSubgroupCoordinators(Vector coords, long timeout) {
        long time_to_wait = 0L;
        int num_rsps_expected = 0;
        if (coords == null || coords.size() <= 1) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"coords == null or size <= 1");
            }
            return;
        }
        Vector vector = this.merge_rsps;
        synchronized (vector) {
            this.merge_rsps.removeAllElements();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("sending MERGE_REQ to " + coords));
            }
            for (int i = 0; i < coords.size(); ++i) {
                Address coord = (Address)coords.elementAt(i);
                if (this.gms.local_addr != null && this.gms.local_addr.equals(coord)) {
                    this.merge_rsps.add(this.getMergeResponse(this.gms.local_addr, this.merge_id));
                    continue;
                }
                Message msg = new Message(coord, null, null);
                GMS.GmsHeader hdr = new GMS.GmsHeader(6);
                hdr.mbr = this.gms.local_addr;
                hdr.merge_id = this.merge_id;
                msg.putHeader(this.gms.getName(), hdr);
                this.gms.passDown(new Event(1, msg));
            }
            num_rsps_expected = coords.size();
            long curr_time = System.currentTimeMillis();
            long end_time = curr_time + timeout;
            while (end_time > curr_time) {
                time_to_wait = end_time - curr_time;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("waiting " + time_to_wait + " msecs for merge responses"));
                }
                if (this.merge_rsps.size() < num_rsps_expected) {
                    try {
                        this.merge_rsps.wait(time_to_wait);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("num_rsps_expected=" + num_rsps_expected + ", actual responses=" + this.merge_rsps.size()));
                }
                if (this.merge_rsps.size() >= num_rsps_expected) break;
                curr_time = System.currentTimeMillis();
            }
        }
    }

    Serializable generateMergeId() {
        return new ViewId(this.gms.local_addr, System.currentTimeMillis());
    }

    MergeData consolidateMergeData(Vector v) {
        Address new_coord;
        MergeData ret = null;
        long logical_time = 0L;
        Membership new_mbrs = new Membership();
        int num_mbrs = 0;
        Digest new_digest = null;
        Vector<Object> subgroups = new Vector<Object>(11);
        for (int i = 0; i < v.size(); ++i) {
            View tmp_view;
            MergeData tmp_data = (MergeData)v.elementAt(i);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("merge data is " + tmp_data));
            }
            if ((tmp_view = tmp_data.getView()) == null) continue;
            ViewId tmp_vid = tmp_view.getVid();
            if (tmp_vid != null) {
                logical_time = Math.max(logical_time, tmp_vid.getId());
            }
            new_mbrs.add(tmp_view.getMembers());
            subgroups.addElement(tmp_view.clone());
        }
        new_mbrs.sort();
        num_mbrs = new_mbrs.size();
        Address address = new_coord = num_mbrs > 0 ? (Address)new_mbrs.elementAt(0) : null;
        if (new_coord == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"new_coord == null");
            }
            return null;
        }
        ViewId new_vid = new ViewId(new_coord, logical_time + 1L);
        MergeView new_view = new MergeView(new_vid, new_mbrs.getMembers(), subgroups);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("new merged view will be " + new_view));
        }
        if ((new_digest = this.consolidateDigests(v, num_mbrs)) == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"digest could not be consolidated");
            }
            return null;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("consolidated digest=" + new_digest));
        }
        ret = new MergeData(this.gms.local_addr, new_view, new_digest);
        return ret;
    }

    Digest consolidateDigests(Vector v, int num_mbrs) {
        Digest retval = new Digest(num_mbrs);
        for (int i = 0; i < v.size(); ++i) {
            MergeData data = (MergeData)v.elementAt(i);
            Digest tmp_digest = data.getDigest();
            if (tmp_digest == null) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)"tmp_digest == null; skipping");
                continue;
            }
            retval.merge(tmp_digest);
        }
        return retval;
    }

    void sendMergeView(Vector coords, MergeData combined_merge_data) {
        if (coords == null || combined_merge_data == null) {
            return;
        }
        View v = combined_merge_data.view;
        Digest d = combined_merge_data.digest;
        if (v == null || d == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"view or digest is null, cannot send consolidated merge view/digest");
            }
            return;
        }
        for (int i = 0; i < coords.size(); ++i) {
            Address coord = (Address)coords.elementAt(i);
            Message msg = new Message(coord, null, null);
            GMS.GmsHeader hdr = new GMS.GmsHeader(8);
            hdr.view = v;
            hdr.my_digest = d;
            hdr.merge_id = this.merge_id;
            msg.putHeader(this.gms.getName(), hdr);
            this.gms.passDown(new Event(1, msg));
        }
    }

    void sendMergeResponse(Address sender, View view, Digest digest) {
        Message msg = new Message(sender, null, null);
        GMS.GmsHeader hdr = new GMS.GmsHeader(7);
        hdr.merge_id = this.merge_id;
        hdr.view = view;
        hdr.my_digest = digest;
        msg.putHeader(this.gms.getName(), hdr);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("response=" + hdr));
        }
        this.gms.passDown(new Event(1, msg));
    }

    void sendMergeRejectedResponse(Address sender) {
        Message msg = new Message(sender, null, null);
        GMS.GmsHeader hdr = new GMS.GmsHeader(7);
        hdr.merge_rejected = true;
        hdr.merge_id = this.merge_id;
        msg.putHeader(this.gms.getName(), hdr);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("response=" + hdr));
        }
        this.gms.passDown(new Event(1, msg));
    }

    void sendMergeCancelledMessage(Vector coords, Serializable merge_id) {
        if (coords == null || merge_id == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"coords or merge_id == null");
            }
            return;
        }
        for (int i = 0; i < coords.size(); ++i) {
            Address coord = (Address)coords.elementAt(i);
            Message msg = new Message(coord, null, null);
            GMS.GmsHeader hdr = new GMS.GmsHeader(9);
            hdr.merge_id = merge_id;
            msg.putHeader(this.gms.getName(), hdr);
            this.gms.passDown(new Event(1, msg));
        }
    }

    void removeRejectedMergeRequests(Vector coords) {
        Iterator it = this.merge_rsps.iterator();
        while (it.hasNext()) {
            MergeData data = (MergeData)it.next();
            if (!data.merge_rejected) continue;
            if (data.getSender() != null && coords != null) {
                coords.removeElement(data.getSender());
            }
            it.remove();
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("removed element " + data));
        }
    }

    private class MergeCanceller
    implements TimeScheduler.Task {
        private Object my_merge_id = null;
        private long timeout;
        private boolean cancelled = false;

        public MergeCanceller(Object my_merge_id, long timeout) {
            this.my_merge_id = my_merge_id;
            this.timeout = timeout;
        }

        public boolean cancelled() {
            return this.cancelled;
        }

        public void cancel() {
            this.cancelled = true;
        }

        public long nextInterval() {
            return this.timeout;
        }

        public void run() {
            if (CoordGmsImpl.this.merge_id != null && this.my_merge_id.equals(CoordGmsImpl.this.merge_id)) {
                if (CoordGmsImpl.this.log.isTraceEnabled()) {
                    CoordGmsImpl.this.log.trace((Object)("cancelling merge due to timer timeout (" + this.timeout + " ms)"));
                }
                CoordGmsImpl.this.cancelMerge();
                this.cancelled = true;
            } else if (CoordGmsImpl.this.log.isTraceEnabled()) {
                CoordGmsImpl.this.log.trace((Object)("timer kicked in after " + this.timeout + " ms, but no (or different) merge was in progress: " + "merge_id=" + CoordGmsImpl.this.merge_id + ", my_merge_id=" + this.my_merge_id));
            }
        }
    }

    private class MergeTask
    implements Runnable {
        Thread t = null;
        Vector coords = null;

        private MergeTask() {
        }

        public void start(Vector coords) {
            if (this.t == null || !this.t.isAlive()) {
                this.coords = (Vector)(coords != null ? coords.clone() : null);
                this.t = new Thread((Runnable)this, "MergeTask thread");
                this.t.setDaemon(true);
                this.t.start();
            }
        }

        public void stop() {
            Thread tmp = this.t;
            if (this.isRunning()) {
                this.t = null;
                tmp.interrupt();
            }
            this.t = null;
            this.coords = null;
        }

        public boolean isRunning() {
            return this.t != null && this.t.isAlive();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block19: {
                block18: {
                    block17: {
                        MergeData combined_merge_data = null;
                        if (CoordGmsImpl.this.merging) {
                            if (!CoordGmsImpl.this.log.isWarnEnabled()) return;
                            CoordGmsImpl.this.log.warn((Object)"merge is already in progress, terminating");
                            return;
                        }
                        if (CoordGmsImpl.this.log.isDebugEnabled()) {
                            CoordGmsImpl.this.log.debug((Object)"merge task started");
                        }
                        try {
                            try {
                                CoordGmsImpl.this.setMergeId(CoordGmsImpl.this.generateMergeId());
                                CoordGmsImpl.this.getMergeDataFromSubgroupCoordinators(this.coords, CoordGmsImpl.this.gms.merge_timeout);
                                CoordGmsImpl.this.removeRejectedMergeRequests(this.coords);
                                if (CoordGmsImpl.this.merge_rsps.size() <= 1) {
                                    if (CoordGmsImpl.this.log.isWarnEnabled()) {
                                        CoordGmsImpl.this.log.warn((Object)("merge responses from subgroup coordinators <= 1 (" + CoordGmsImpl.this.merge_rsps + "). Cancelling merge"));
                                    }
                                    CoordGmsImpl.this.sendMergeCancelledMessage(this.coords, CoordGmsImpl.this.merge_id);
                                    Object var4_2 = null;
                                    break block17;
                                }
                                combined_merge_data = CoordGmsImpl.this.consolidateMergeData(CoordGmsImpl.this.merge_rsps);
                                if (combined_merge_data == null) {
                                    if (CoordGmsImpl.this.log.isErrorEnabled()) {
                                        CoordGmsImpl.this.log.error((Object)"combined_merge_data == null");
                                    }
                                    CoordGmsImpl.this.sendMergeCancelledMessage(this.coords, CoordGmsImpl.this.merge_id);
                                    break block18;
                                }
                                CoordGmsImpl.this.sendMergeView(this.coords, combined_merge_data);
                                break block19;
                            }
                            catch (Throwable ex) {
                                if (CoordGmsImpl.this.log.isErrorEnabled()) {
                                    CoordGmsImpl.this.log.error((Object)("exception=" + ex));
                                }
                                Object var4_5 = null;
                                CoordGmsImpl.this.merging = false;
                                CoordGmsImpl.this.merge_leader = null;
                                if (CoordGmsImpl.this.log.isDebugEnabled()) {
                                    CoordGmsImpl.this.log.debug((Object)"merge task terminated");
                                }
                                this.t = null;
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var4_6 = null;
                            CoordGmsImpl.this.merging = false;
                            CoordGmsImpl.this.merge_leader = null;
                            if (CoordGmsImpl.this.log.isDebugEnabled()) {
                                CoordGmsImpl.this.log.debug((Object)"merge task terminated");
                            }
                            this.t = null;
                            throw throwable;
                        }
                    }
                    CoordGmsImpl.this.merging = false;
                    CoordGmsImpl.this.merge_leader = null;
                    if (CoordGmsImpl.this.log.isDebugEnabled()) {
                        CoordGmsImpl.this.log.debug((Object)"merge task terminated");
                    }
                    this.t = null;
                    return;
                }
                Object var4_3 = null;
                CoordGmsImpl.this.merging = false;
                CoordGmsImpl.this.merge_leader = null;
                if (CoordGmsImpl.this.log.isDebugEnabled()) {
                    CoordGmsImpl.this.log.debug((Object)"merge task terminated");
                }
                this.t = null;
                return;
            }
            Object var4_4 = null;
            CoordGmsImpl.this.merging = false;
            CoordGmsImpl.this.merge_leader = null;
            if (CoordGmsImpl.this.log.isDebugEnabled()) {
                CoordGmsImpl.this.log.debug((Object)"merge task terminated");
            }
            this.t = null;
        }
    }
}

