/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.opt.graph.sparse.specifics;

import java.util.Set;
import org.jgrapht.GraphType;
import org.jgrapht.opt.graph.sparse.specifics.CompleteIntegerSet;

public interface SparseGraphSpecifics {
    public long edgesCount();

    public long verticesCount();

    default public boolean containsEdge(Integer e) {
        return e >= 0 && (long)e.intValue() < this.edgesCount();
    }

    default public boolean containsVertex(Integer v) {
        return v >= 0 && (long)v.intValue() < this.verticesCount();
    }

    default public Set<Integer> edgeSet() {
        Long edgesCount = this.edgesCount();
        if (edgesCount > Integer.MAX_VALUE) {
            throw new ArithmeticException("integer overflow");
        }
        return new CompleteIntegerSet(edgesCount.intValue());
    }

    public long degreeOf(Integer var1);

    public Set<Integer> edgesOf(Integer var1);

    public long inDegreeOf(Integer var1);

    public Set<Integer> incomingEdgesOf(Integer var1);

    public long outDegreeOf(Integer var1);

    public Set<Integer> outgoingEdgesOf(Integer var1);

    default public Set<Integer> vertexSet() {
        Long verticesCount = this.verticesCount();
        if (verticesCount > Integer.MAX_VALUE) {
            throw new ArithmeticException("integer overflow");
        }
        return new CompleteIntegerSet(verticesCount.intValue());
    }

    public Integer getEdgeSource(Integer var1);

    public Integer getEdgeTarget(Integer var1);

    public GraphType getType();

    default public double getEdgeWeight(Integer e) {
        return 1.0;
    }

    default public void setEdgeWeight(Integer e, double weight) {
        throw new UnsupportedOperationException("this graph is unmodifiable");
    }

    public Integer getEdge(Integer var1, Integer var2);

    public Set<Integer> getAllEdges(Integer var1, Integer var2);

    default public boolean assertVertexExist(Integer v) {
        if (v >= 0 && (long)v.intValue() < this.verticesCount()) {
            return true;
        }
        throw new IllegalArgumentException("no such vertex in graph: " + v.toString());
    }

    default public boolean assertEdgeExist(Integer e) {
        if (e >= 0 && (long)e.intValue() < this.edgesCount()) {
            return true;
        }
        throw new IllegalArgumentException("no such edge in graph: " + e.toString());
    }
}

