/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.io;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;
import org.jgrapht.Graph;
import org.jgrapht.io.AbstractBaseExporter;
import org.jgrapht.io.ComponentNameProvider;
import org.jgrapht.io.GraphExporter;
import org.jgrapht.io.IntegerComponentNameProvider;

public class GmlExporter<V, E>
extends AbstractBaseExporter<V, E>
implements GraphExporter<V, E> {
    private static final String CREATOR = "JGraphT GML Exporter";
    private static final String VERSION = "1";
    private static final String DELIM = " ";
    private static final String TAB1 = "\t";
    private static final String TAB2 = "\t\t";
    private ComponentNameProvider<V> vertexLabelProvider;
    private ComponentNameProvider<E> edgeLabelProvider;
    private final Set<Parameter> parameters;

    public GmlExporter() {
        this(new IntegerComponentNameProvider(), null, new IntegerComponentNameProvider(), null);
    }

    public GmlExporter(ComponentNameProvider<V> vertexIDProvider, ComponentNameProvider<V> vertexLabelProvider, ComponentNameProvider<E> edgeIDProvider, ComponentNameProvider<E> edgeLabelProvider) {
        super(vertexIDProvider, Objects.requireNonNull(edgeIDProvider, "Edge ID provider cannot be null"));
        this.vertexLabelProvider = vertexLabelProvider;
        this.edgeLabelProvider = edgeLabelProvider;
        this.parameters = new HashSet<Parameter>();
    }

    private String quoted(String s) {
        boolean escapeStringAsJava = this.parameters.contains((Object)Parameter.ESCAPE_STRINGS_AS_JAVA);
        if (escapeStringAsJava) {
            return "\"" + StringEscapeUtils.escapeJava((String)s) + "\"";
        }
        return "\"" + s + "\"";
    }

    private void exportHeader(PrintWriter out) {
        out.println("Creator " + this.quoted(CREATOR));
        out.println("Version 1");
    }

    private void exportVertices(PrintWriter out, Graph<V, E> g) {
        boolean exportVertexLabels = this.parameters.contains((Object)Parameter.EXPORT_VERTEX_LABELS);
        for (Object from : g.vertexSet()) {
            out.println("\tnode");
            out.println("\t[");
            out.println("\t\tid " + this.vertexIDProvider.getName(from));
            if (exportVertexLabels) {
                String label = this.vertexLabelProvider == null ? from.toString() : this.vertexLabelProvider.getName(from);
                out.println("\t\tlabel " + this.quoted(label));
            }
            out.println("\t]");
        }
    }

    private void exportEdges(PrintWriter out, Graph<V, E> g) {
        boolean exportEdgeWeights = this.parameters.contains((Object)Parameter.EXPORT_EDGE_WEIGHTS);
        boolean exportEdgeLabels = this.parameters.contains((Object)Parameter.EXPORT_EDGE_LABELS);
        for (Object edge : g.edgeSet()) {
            out.println("\tedge");
            out.println("\t[");
            String id = this.edgeIDProvider.getName(edge);
            out.println("\t\tid " + id);
            String s = this.vertexIDProvider.getName(g.getEdgeSource(edge));
            out.println("\t\tsource " + s);
            String t = this.vertexIDProvider.getName(g.getEdgeTarget(edge));
            out.println("\t\ttarget " + t);
            if (exportEdgeLabels) {
                String label = this.edgeLabelProvider == null ? edge.toString() : this.edgeLabelProvider.getName(edge);
                out.println("\t\tlabel " + this.quoted(label));
            }
            if (exportEdgeWeights && g.getType().isWeighted()) {
                out.println("\t\tweight " + Double.toString(g.getEdgeWeight(edge)));
            }
            out.println("\t]");
        }
    }

    @Override
    public void exportGraph(Graph<V, E> g, Writer writer) {
        PrintWriter out = new PrintWriter(writer);
        for (Object from : g.vertexSet()) {
            this.vertexIDProvider.getName(from);
        }
        this.exportHeader(out);
        out.println("graph");
        out.println("[");
        out.println("\tlabel " + this.quoted(""));
        if (g.getType().isDirected()) {
            out.println("\tdirected 1");
        } else {
            out.println("\tdirected 0");
        }
        this.exportVertices(out, g);
        this.exportEdges(out, g);
        out.println("]");
        out.flush();
    }

    public boolean isParameter(Parameter p) {
        return this.parameters.contains((Object)p);
    }

    public void setParameter(Parameter p, boolean value) {
        if (value) {
            this.parameters.add(p);
        } else {
            this.parameters.remove((Object)p);
        }
    }

    public static enum Parameter {
        EXPORT_EDGE_LABELS,
        EXPORT_VERTEX_LABELS,
        EXPORT_EDGE_WEIGHTS,
        ESCAPE_STRINGS_AS_JAVA;

    }
}

