/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph.guava;

import com.google.common.graph.EndpointPair;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.function.Supplier;
import org.jgrapht.Graph;
import org.jgrapht.GraphType;
import org.jgrapht.graph.guava.BaseGraphAdapter;
import org.jgrapht.graph.guava.ElementOrderMethod;
import org.jgrapht.util.TypeUtil;

public class MutableGraphAdapter<V>
extends BaseGraphAdapter<V, MutableGraph<V>>
implements Graph<V, EndpointPair<V>>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -7556855931445010748L;

    public MutableGraphAdapter(MutableGraph<V> graph) {
        this(graph, (Supplier<V>)null, (Supplier<EndpointPair<V>>)null);
    }

    public MutableGraphAdapter(MutableGraph<V> graph, Supplier<V> vertexSupplier, Supplier<EndpointPair<V>> edgeSupplier) {
        super(graph, vertexSupplier, edgeSupplier, ElementOrderMethod.internal());
    }

    public MutableGraphAdapter(MutableGraph<V> graph, Supplier<V> vertexSupplier, Supplier<EndpointPair<V>> edgeSupplier, ElementOrderMethod<V> vertexOrderMethod) {
        super(graph, vertexSupplier, edgeSupplier, vertexOrderMethod);
    }

    public EndpointPair<V> addEdge(V sourceVertex, V targetVertex) {
        this.assertVertexExist(sourceVertex);
        this.assertVertexExist(targetVertex);
        if (this.containsEdge(sourceVertex, targetVertex)) {
            return null;
        }
        if (!((MutableGraph)this.graph).allowsSelfLoops() && sourceVertex.equals(targetVertex)) {
            throw new IllegalArgumentException("loops not allowed");
        }
        ((MutableGraph)this.graph).putEdge(sourceVertex, targetVertex);
        return this.createEdge(sourceVertex, targetVertex);
    }

    public boolean addEdge(V sourceVertex, V targetVertex, EndpointPair<V> e) {
        this.assertVertexExist(sourceVertex);
        this.assertVertexExist(targetVertex);
        if (e != null) {
            if (!sourceVertex.equals(e.nodeU())) {
                throw new IllegalArgumentException("Provided edge must have node U equal to source vertex");
            }
            if (!targetVertex.equals(e.nodeV())) {
                throw new IllegalArgumentException("Provided edge must have node V equal to target vertex");
            }
        }
        if (this.containsEdge(sourceVertex, targetVertex)) {
            return false;
        }
        if (!((MutableGraph)this.graph).allowsSelfLoops() && sourceVertex.equals(targetVertex)) {
            throw new IllegalArgumentException("loops not allowed");
        }
        ((MutableGraph)this.graph).putEdge(sourceVertex, targetVertex);
        return true;
    }

    public V addVertex() {
        if (this.vertexSupplier == null) {
            throw new UnsupportedOperationException("The graph contains no vertex supplier");
        }
        Object v = this.vertexSupplier.get();
        if (((MutableGraph)this.graph).addNode(v)) {
            return (V)v;
        }
        return null;
    }

    public boolean addVertex(V v) {
        return ((MutableGraph)this.graph).addNode(v);
    }

    public EndpointPair<V> removeEdge(V sourceVertex, V targetVertex) {
        EndpointPair<V> e = this.getEdge(sourceVertex, targetVertex);
        if (e != null) {
            ((MutableGraph)this.graph).removeEdge(sourceVertex, targetVertex);
        }
        return e;
    }

    public boolean removeEdge(EndpointPair<V> e) {
        if (e == null) {
            return false;
        }
        return ((MutableGraph)this.graph).removeEdge(e.nodeU(), e.nodeV());
    }

    public boolean removeVertex(V v) {
        this.vertexOrder.notifyRemoval(v);
        return ((MutableGraph)this.graph).removeNode(v);
    }

    public void setEdgeWeight(EndpointPair<V> e, double weight) {
        throw new UnsupportedOperationException("Graph is unweighted");
    }

    public Object clone() {
        try {
            MutableGraphAdapter newGraph = (MutableGraphAdapter)TypeUtil.uncheckedCast((Object)super.clone());
            newGraph.vertexSupplier = this.vertexSupplier;
            newGraph.edgeSupplier = this.edgeSupplier;
            newGraph.unmodifiableVertexSet = null;
            newGraph.unmodifiableEdgeSet = null;
            newGraph.graph = Graphs.copyOf((com.google.common.graph.Graph)this.graph);
            newGraph.vertexOrder = this.createVertexOrder(newGraph.vertexOrderMethod);
            return newGraph;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.getType());
        int n = this.vertexSet().size();
        oos.writeInt(n);
        for (Object v : this.vertexSet()) {
            oos.writeObject(v);
        }
        int m = this.edgeSet().size();
        oos.writeInt(m);
        for (EndpointPair e : this.edgeSet()) {
            Object u = e.nodeU();
            Object v = e.nodeV();
            oos.writeObject(u);
            oos.writeObject(v);
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        GraphType type = (GraphType)ois.readObject();
        if (type.isMixed() || type.isAllowingMultipleEdges()) {
            throw new IOException("Graph type not supported");
        }
        this.graph = (type.isDirected() ? GraphBuilder.directed() : GraphBuilder.undirected()).allowsSelfLoops(type.isAllowingSelfLoops()).build();
        int n = ois.readInt();
        for (int i = 0; i < n; ++i) {
            Object v = ois.readObject();
            ((MutableGraph)this.graph).addNode(v);
        }
        int m = ois.readInt();
        for (int i = 0; i < m; ++i) {
            Object s = ois.readObject();
            Object t = ois.readObject();
            ((MutableGraph)this.graph).putEdge(s, t);
        }
        this.vertexOrder = this.createVertexOrder(this.vertexOrderMethod);
    }
}

