/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph.guava;

import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graphs;
import com.google.common.graph.ImmutableValueGraph;
import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.ValueGraph;
import com.google.common.graph.ValueGraphBuilder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.function.ToDoubleFunction;
import org.jgrapht.Graph;
import org.jgrapht.GraphType;
import org.jgrapht.graph.guava.BaseValueGraphAdapter;
import org.jgrapht.util.TypeUtil;

public class ImmutableValueGraphAdapter<V, W>
extends BaseValueGraphAdapter<V, W, ImmutableValueGraph<V, W>>
implements Graph<V, EndpointPair<V>>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 2629294259825656044L;
    protected static final String GRAPH_IS_IMMUTABLE = "Graph is immutable";

    public ImmutableValueGraphAdapter(ImmutableValueGraph<V, W> valueGraph, ToDoubleFunction<W> valueConverter) {
        super(valueGraph, valueConverter);
    }

    public EndpointPair<V> addEdge(V sourceVertex, V targetVertex) {
        throw new UnsupportedOperationException(GRAPH_IS_IMMUTABLE);
    }

    public boolean addEdge(V sourceVertex, V targetVertex, EndpointPair<V> e) {
        throw new UnsupportedOperationException(GRAPH_IS_IMMUTABLE);
    }

    public V addVertex() {
        throw new UnsupportedOperationException(GRAPH_IS_IMMUTABLE);
    }

    public boolean addVertex(V v) {
        throw new UnsupportedOperationException(GRAPH_IS_IMMUTABLE);
    }

    public EndpointPair<V> removeEdge(V sourceVertex, V targetVertex) {
        throw new UnsupportedOperationException(GRAPH_IS_IMMUTABLE);
    }

    public boolean removeEdge(EndpointPair<V> e) {
        throw new UnsupportedOperationException(GRAPH_IS_IMMUTABLE);
    }

    public boolean removeVertex(V v) {
        throw new UnsupportedOperationException(GRAPH_IS_IMMUTABLE);
    }

    public void setEdgeWeight(EndpointPair<V> e, double weight) {
        throw new UnsupportedOperationException(GRAPH_IS_IMMUTABLE);
    }

    @Override
    public GraphType getType() {
        return super.getType().asUnmodifiable();
    }

    public Object clone() {
        try {
            ImmutableValueGraphAdapter newGraph = (ImmutableValueGraphAdapter)TypeUtil.uncheckedCast((Object)super.clone());
            newGraph.vertexSupplier = this.vertexSupplier;
            newGraph.edgeSupplier = this.edgeSupplier;
            newGraph.unmodifiableVertexSet = null;
            newGraph.unmodifiableEdgeSet = null;
            newGraph.valueConverter = this.valueConverter;
            newGraph.valueGraph = ImmutableValueGraph.copyOf((ValueGraph)Graphs.copyOf((ValueGraph)this.valueGraph));
            newGraph.vertexOrder = this.createVertexOrder(newGraph.vertexOrderMethod);
            return newGraph;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.getType());
        int n = this.vertexSet().size();
        oos.writeInt(n);
        for (Object v : this.vertexSet()) {
            oos.writeObject(v);
        }
        int m = this.edgeSet().size();
        oos.writeInt(m);
        for (EndpointPair e : this.edgeSet()) {
            Object u = e.nodeU();
            Object v = e.nodeV();
            oos.writeObject(u);
            oos.writeObject(v);
            oos.writeObject(((ImmutableValueGraph)this.valueGraph).edgeValue(u, v).get());
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        GraphType type = (GraphType)ois.readObject();
        if (type.isMixed() || type.isAllowingMultipleEdges()) {
            throw new IOException("Graph type not supported");
        }
        MutableValueGraph mutableValueGraph = (type.isDirected() ? ValueGraphBuilder.directed() : ValueGraphBuilder.undirected()).allowsSelfLoops(type.isAllowingSelfLoops()).build();
        int n = ois.readInt();
        for (int i = 0; i < n; ++i) {
            Object v = ois.readObject();
            mutableValueGraph.addNode(v);
        }
        int m = ois.readInt();
        for (int i = 0; i < m; ++i) {
            Object s = ois.readObject();
            Object t = ois.readObject();
            Object w = ois.readObject();
            mutableValueGraph.putEdgeValue(s, t, w);
        }
        this.vertexOrder = this.createVertexOrder(this.vertexOrderMethod);
        this.valueGraph = ImmutableValueGraph.copyOf((ValueGraph)mutableValueGraph);
    }
}

