/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph.guava;

import com.google.common.graph.EndpointPair;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.MutableGraph;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jgrapht.Graph;
import org.jgrapht.GraphType;
import org.jgrapht.graph.guava.BaseGraphAdapter;
import org.jgrapht.util.TypeUtil;

public class ImmutableGraphAdapter<V>
extends BaseGraphAdapter<V, ImmutableGraph<V>>
implements Graph<V, EndpointPair<V>>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -6619929013881511474L;
    protected static final String GRAPH_IS_IMMUTABLE = "Graph is immutable";

    public ImmutableGraphAdapter(ImmutableGraph<V> graph) {
        super(graph);
    }

    public EndpointPair<V> addEdge(V sourceVertex, V targetVertex) {
        throw new UnsupportedOperationException(GRAPH_IS_IMMUTABLE);
    }

    public boolean addEdge(V sourceVertex, V targetVertex, EndpointPair<V> e) {
        throw new UnsupportedOperationException(GRAPH_IS_IMMUTABLE);
    }

    public V addVertex() {
        throw new UnsupportedOperationException(GRAPH_IS_IMMUTABLE);
    }

    public boolean addVertex(V v) {
        throw new UnsupportedOperationException(GRAPH_IS_IMMUTABLE);
    }

    public EndpointPair<V> removeEdge(V sourceVertex, V targetVertex) {
        throw new UnsupportedOperationException(GRAPH_IS_IMMUTABLE);
    }

    public boolean removeEdge(EndpointPair<V> e) {
        throw new UnsupportedOperationException(GRAPH_IS_IMMUTABLE);
    }

    public boolean removeVertex(V v) {
        throw new UnsupportedOperationException(GRAPH_IS_IMMUTABLE);
    }

    public void setEdgeWeight(EndpointPair<V> e, double weight) {
        throw new UnsupportedOperationException(GRAPH_IS_IMMUTABLE);
    }

    @Override
    public GraphType getType() {
        return super.getType().asUnmodifiable();
    }

    public Object clone() {
        try {
            ImmutableGraphAdapter newGraph = (ImmutableGraphAdapter)TypeUtil.uncheckedCast((Object)super.clone());
            newGraph.unmodifiableVertexSet = null;
            newGraph.unmodifiableEdgeSet = null;
            newGraph.graph = ImmutableGraph.copyOf((com.google.common.graph.Graph)Graphs.copyOf((com.google.common.graph.Graph)this.graph));
            return newGraph;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.getType());
        int n = this.vertexSet().size();
        oos.writeInt(n);
        for (Object v : this.vertexSet()) {
            oos.writeObject(v);
        }
        int m = this.edgeSet().size();
        oos.writeInt(m);
        for (EndpointPair e : this.edgeSet()) {
            Object u = e.nodeU();
            Object v = e.nodeV();
            oos.writeObject(u);
            oos.writeObject(v);
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        GraphType type = (GraphType)ois.readObject();
        if (type.isMixed() || type.isAllowingMultipleEdges()) {
            throw new IOException("Graph type not supported");
        }
        MutableGraph mutableGraph = (type.isDirected() ? GraphBuilder.directed() : GraphBuilder.undirected()).allowsSelfLoops(type.isAllowingSelfLoops()).build();
        int n = ois.readInt();
        for (int i = 0; i < n; ++i) {
            Object v = ois.readObject();
            mutableGraph.addNode(v);
        }
        int m = ois.readInt();
        for (int i = 0; i < m; ++i) {
            Object s = ois.readObject();
            Object t = ois.readObject();
            mutableGraph.putEdge(s, t);
        }
        this.graph = ImmutableGraph.copyOf((com.google.common.graph.Graph)mutableGraph);
    }
}

