/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.demo;

import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleGraph;
import org.jgrapht.nio.Attribute;
import org.jgrapht.nio.DefaultAttribute;
import org.jgrapht.nio.ExportException;
import org.jgrapht.nio.dot.DOTExporter;
import org.jgrapht.traverse.DepthFirstIterator;

public final class HelloJGraphT {
    private HelloJGraphT() {
    }

    public static void main(String[] args) throws URISyntaxException, ExportException {
        Graph<String, DefaultEdge> stringGraph = HelloJGraphT.createStringGraph();
        System.out.println("-- toString output");
        System.out.println(stringGraph.toString());
        System.out.println();
        Graph<URI, DefaultEdge> hrefGraph = HelloJGraphT.createHrefGraph();
        URI start = hrefGraph.vertexSet().stream().filter(uri -> uri.getHost().equals("www.jgrapht.org")).findAny().get();
        System.out.println("-- traverseHrefGraph output");
        HelloJGraphT.traverseHrefGraph(hrefGraph, start);
        System.out.println();
        System.out.println("-- renderHrefGraph output");
        HelloJGraphT.renderHrefGraph(hrefGraph);
        System.out.println();
    }

    private static Graph<URI, DefaultEdge> createHrefGraph() throws URISyntaxException {
        DefaultDirectedGraph g = new DefaultDirectedGraph(DefaultEdge.class);
        URI google = new URI("http://www.google.com");
        URI wikipedia = new URI("http://www.wikipedia.org");
        URI jgrapht = new URI("http://www.jgrapht.org");
        g.addVertex((Object)google);
        g.addVertex((Object)wikipedia);
        g.addVertex((Object)jgrapht);
        g.addEdge((Object)jgrapht, (Object)wikipedia);
        g.addEdge((Object)google, (Object)jgrapht);
        g.addEdge((Object)google, (Object)wikipedia);
        g.addEdge((Object)wikipedia, (Object)google);
        return g;
    }

    private static void traverseHrefGraph(Graph<URI, DefaultEdge> hrefGraph, URI start) {
        DepthFirstIterator iterator = new DepthFirstIterator(hrefGraph, (Object)start);
        while (iterator.hasNext()) {
            URI uri = (URI)iterator.next();
            System.out.println(uri);
        }
    }

    private static void renderHrefGraph(Graph<URI, DefaultEdge> hrefGraph) throws ExportException {
        DOTExporter exporter = new DOTExporter(v -> v.getHost().replace('.', '_'));
        exporter.setVertexAttributeProvider(v -> {
            LinkedHashMap<String, Attribute> map = new LinkedHashMap<String, Attribute>();
            map.put("label", DefaultAttribute.createAttribute((String)v.toString()));
            return map;
        });
        StringWriter writer = new StringWriter();
        exporter.exportGraph(hrefGraph, (Writer)writer);
        System.out.println(((Object)writer).toString());
    }

    private static Graph<String, DefaultEdge> createStringGraph() {
        SimpleGraph g = new SimpleGraph(DefaultEdge.class);
        String v1 = "v1";
        String v2 = "v2";
        String v3 = "v3";
        String v4 = "v4";
        g.addVertex((Object)v1);
        g.addVertex((Object)v2);
        g.addVertex((Object)v3);
        g.addVertex((Object)v4);
        g.addEdge((Object)v1, (Object)v2);
        g.addEdge((Object)v2, (Object)v3);
        g.addEdge((Object)v3, (Object)v4);
        g.addEdge((Object)v4, (Object)v1);
        return g;
    }
}

