/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.demo;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jgrapht.Graph;
import org.jgrapht.generate.CompleteGraphGenerator;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.builder.GraphTypeBuilder;
import org.jgrapht.nio.Attribute;
import org.jgrapht.nio.AttributeType;
import org.jgrapht.nio.DefaultAttribute;
import org.jgrapht.nio.GraphExporter;
import org.jgrapht.nio.GraphImporter;
import org.jgrapht.nio.IntegerIdProvider;
import org.jgrapht.nio.graphml.GraphMLExporter;
import org.jgrapht.nio.graphml.GraphMLImporter;
import org.jgrapht.util.SupplierUtil;

public final class GraphMLDemo {
    private static final int SIZE = 6;
    private static final Random GENERATOR = new Random(17L);

    private static GraphExporter<CustomVertex, DefaultWeightedEdge> createExporter() {
        GraphMLExporter exporter = new GraphMLExporter(v -> v.id);
        exporter.setExportEdgeWeights(true);
        exporter.setVertexAttributeProvider(v -> {
            HashMap<String, Attribute> m = new HashMap<String, Attribute>();
            if (v.getColor() != null) {
                m.put("color", DefaultAttribute.createAttribute((String)v.getColor().toString()));
            }
            m.put("name", DefaultAttribute.createAttribute((String)("node-" + v.id)));
            return m;
        });
        exporter.setEdgeIdProvider((Function)new IntegerIdProvider(0));
        exporter.setEdgeAttributeProvider(e -> {
            HashMap<String, Attribute> m = new HashMap<String, Attribute>();
            m.put("name", DefaultAttribute.createAttribute((String)e.toString()));
            return m;
        });
        exporter.registerAttribute("color", GraphMLExporter.AttributeCategory.NODE, AttributeType.STRING);
        exporter.registerAttribute("name", GraphMLExporter.AttributeCategory.ALL, AttributeType.STRING);
        return exporter;
    }

    private static GraphImporter<CustomVertex, DefaultWeightedEdge> createImporter() {
        GraphMLImporter importer = new GraphMLImporter();
        importer.addVertexAttributeConsumer((p, attrValue) -> {
            CustomVertex v = (CustomVertex)p.getFirst();
            String attrName = (String)p.getSecond();
            if (attrName.equals("color")) {
                String color;
                switch (color = attrValue.getValue()) {
                    case "black": {
                        v.setColor(Color.BLACK);
                        break;
                    }
                    case "white": {
                        v.setColor(Color.WHITE);
                    }
                }
            }
        });
        return importer;
    }

    public static void main(String[] args) {
        Graph graph1 = GraphTypeBuilder.directed().weighted(true).allowingMultipleEdges(true).allowingSelfLoops(true).vertexSupplier((Supplier)new CustomVertexSupplier()).edgeSupplier(SupplierUtil.createDefaultWeightedEdgeSupplier()).buildGraph();
        CompleteGraphGenerator completeGenerator = new CompleteGraphGenerator(6);
        System.out.println("-- Generating complete graph");
        completeGenerator.generateGraph(graph1);
        for (DefaultWeightedEdge e : graph1.edgeSet()) {
            graph1.setEdgeWeight((Object)e, (double)GENERATOR.nextInt(100));
        }
        System.out.println("-- Exporting graph as GraphML");
        GraphExporter<CustomVertex, DefaultWeightedEdge> exporter = GraphMLDemo.createExporter();
        StringWriter writer = new StringWriter();
        exporter.exportGraph(graph1, (Writer)writer);
        String graph1AsGraphML = ((Object)writer).toString();
        System.out.println(graph1AsGraphML);
        System.out.println("-- Importing graph back from GraphML");
        Graph graph2 = GraphTypeBuilder.directed().weighted(true).allowingMultipleEdges(true).allowingSelfLoops(true).vertexSupplier((Supplier)new CustomVertexSupplier()).edgeSupplier(SupplierUtil.createDefaultWeightedEdgeSupplier()).buildGraph();
        GraphImporter<CustomVertex, DefaultWeightedEdge> importer = GraphMLDemo.createImporter();
        importer.importGraph(graph2, (Reader)new StringReader(graph1AsGraphML));
    }

    static class CustomVertexSupplier
    implements Supplier<CustomVertex> {
        private int id = 0;

        CustomVertexSupplier() {
        }

        @Override
        public CustomVertex get() {
            return new CustomVertex(String.valueOf(this.id++), GENERATOR.nextBoolean() ? Color.BLACK : Color.WHITE);
        }
    }

    static class CustomVertex {
        private String id;
        private Color color;

        public CustomVertex(String id) {
            this(id, null);
        }

        public CustomVertex(String id, Color color) {
            this.id = id;
            this.color = color;
        }

        public int hashCode() {
            return this.id == null ? 0 : this.id.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CustomVertex other = (CustomVertex)obj;
            if (this.id == null) {
                return other.id == null;
            }
            return this.id.equals(other.id);
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("(").append(this.id);
            if (this.color != null) {
                sb.append(",").append((Object)this.color);
            }
            sb.append(")");
            return sb.toString();
        }
    }

    static enum Color {
        BLACK("black"),
        WHITE("white");

        private final String value;

        private Color(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

