/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.util.function.Supplier;
import org.jgrapht.EdgeFactory;
import org.jgrapht.graph.AbstractBaseGraph;
import org.jgrapht.graph.DefaultGraphType;
import org.jgrapht.graph.builder.GraphBuilder;
import org.jgrapht.util.SupplierUtil;

public class SimpleDirectedGraph<V, E>
extends AbstractBaseGraph<V, E> {
    private static final long serialVersionUID = 1665314455034181409L;

    public SimpleDirectedGraph(Class<? extends E> edgeClass) {
        this(null, SupplierUtil.createSupplier(edgeClass), false);
    }

    public SimpleDirectedGraph(Supplier<V> vertexSupplier, Supplier<E> edgeSupplier, boolean weighted) {
        super(vertexSupplier, edgeSupplier, new DefaultGraphType.Builder().directed().allowMultipleEdges(false).allowSelfLoops(false).weighted(weighted).build());
    }

    public static <V, E> GraphBuilder<V, E, ? extends SimpleDirectedGraph<V, E>> createBuilder(Class<? extends E> edgeClass) {
        return new GraphBuilder(new SimpleDirectedGraph<V, E>(edgeClass));
    }

    public static <V, E> GraphBuilder<V, E, ? extends SimpleDirectedGraph<V, E>> createBuilder(Supplier<E> edgeSupplier) {
        return new GraphBuilder(new SimpleDirectedGraph<V, E>(null, edgeSupplier, false));
    }

    @Deprecated
    public SimpleDirectedGraph(EdgeFactory<V, E> ef, boolean weighted) {
        super(ef, true, false, false, weighted);
    }

    @Deprecated
    public SimpleDirectedGraph(EdgeFactory<V, E> ef) {
        this(ef, false);
    }

    @Deprecated
    public static <V, E> GraphBuilder<V, E, ? extends SimpleDirectedGraph<V, E>> createBuilder(EdgeFactory<V, E> ef) {
        return new GraphBuilder(new SimpleDirectedGraph<V, E>(ef));
    }
}

