/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph.specifics;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.graph.AbstractBaseGraph;
import org.jgrapht.graph.specifics.UndirectedEdgeContainer;
import org.jgrapht.graph.specifics.UndirectedSpecifics;
import org.jgrapht.util.ArrayUnenforcedSet;
import org.jgrapht.util.UnorderedVertexPair;
import org.jgrapht.util.VertexPair;

public class FastLookupUndirectedSpecifics<V, E>
extends UndirectedSpecifics<V, E>
implements Serializable {
    private static final long serialVersionUID = 225772727571597846L;
    protected Map<VertexPair<V>, ArrayUnenforcedSet<E>> touchingVerticesToEdgeMap = new HashMap<VertexPair<V>, ArrayUnenforcedSet<E>>();

    public FastLookupUndirectedSpecifics(AbstractBaseGraph<V, E> abstractBaseGraph) {
        this(abstractBaseGraph, new LinkedHashMap());
    }

    public FastLookupUndirectedSpecifics(AbstractBaseGraph<V, E> abstractBaseGraph, Map<V, UndirectedEdgeContainer<V, E>> vertexMap) {
        super(abstractBaseGraph, vertexMap);
    }

    @Override
    public Set<E> getAllEdges(V sourceVertex, V targetVertex) {
        if (this.abstractBaseGraph.containsVertex(sourceVertex) && this.abstractBaseGraph.containsVertex(targetVertex)) {
            Set edges = this.touchingVerticesToEdgeMap.get(new UnorderedVertexPair<V>(sourceVertex, targetVertex));
            return edges == null ? Collections.emptySet() : new ArrayUnenforcedSet(edges);
        }
        return null;
    }

    @Override
    public E getEdge(V sourceVertex, V targetVertex) {
        List edges = this.touchingVerticesToEdgeMap.get(new UnorderedVertexPair<V>(sourceVertex, targetVertex));
        if (edges == null || edges.isEmpty()) {
            return null;
        }
        return edges.get(0);
    }

    @Override
    public void addEdgeToTouchingVertices(E e) {
        Object source = this.abstractBaseGraph.getEdgeSource(e);
        Object target = this.abstractBaseGraph.getEdgeTarget(e);
        this.getEdgeContainer(source).addEdge(e);
        UnorderedVertexPair vertexPair = new UnorderedVertexPair(source, target);
        if (!this.touchingVerticesToEdgeMap.containsKey(vertexPair)) {
            ArrayUnenforcedSet<E> edgeSet = new ArrayUnenforcedSet<E>();
            edgeSet.add(e);
            this.touchingVerticesToEdgeMap.put(vertexPair, edgeSet);
        } else {
            this.touchingVerticesToEdgeMap.get(vertexPair).add(e);
        }
        if (!source.equals(target)) {
            this.getEdgeContainer(target).addEdge(e);
        }
    }

    @Override
    public void removeEdgeFromTouchingVertices(E e) {
        UnorderedVertexPair vertexPair;
        Object source = this.abstractBaseGraph.getEdgeSource(e);
        Object target = this.abstractBaseGraph.getEdgeTarget(e);
        this.getEdgeContainer(source).removeEdge(e);
        if (!source.equals(target)) {
            this.getEdgeContainer(target).removeEdge(e);
        }
        if (this.touchingVerticesToEdgeMap.containsKey(vertexPair = new UnorderedVertexPair(source, target))) {
            ArrayUnenforcedSet<E> edgeSet = this.touchingVerticesToEdgeMap.get(vertexPair);
            edgeSet.remove(e);
            if (edgeSet.isEmpty()) {
                this.touchingVerticesToEdgeMap.remove(vertexPair);
            }
        }
    }
}

