/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.graph.MaskFunctor;
import org.jgrapht.util.PrefetchIterator;
import org.jgrapht.util.TypeUtil;

class MaskEdgeSet<V, E>
extends AbstractSet<E> {
    private Set<E> edgeSet;
    private Graph<V, E> graph;
    private MaskFunctor<V, E> mask;
    private transient TypeUtil<E> edgeTypeDecl = null;

    public MaskEdgeSet(Graph<V, E> graph, Set<E> edgeSet, MaskFunctor<V, E> mask) {
        this.graph = graph;
        this.edgeSet = edgeSet;
        this.mask = mask;
    }

    @Override
    public boolean contains(Object o) {
        Object e = o;
        return this.edgeSet.contains(e) && !this.mask.isEdgeMasked(e) && !this.mask.isVertexMasked(this.graph.getEdgeSource(e)) && !this.mask.isVertexMasked(this.graph.getEdgeTarget(e));
    }

    @Override
    public Iterator<E> iterator() {
        return new PrefetchIterator(new MaskEdgeSetNextElementFunctor());
    }

    @Override
    public int size() {
        return (int)this.edgeSet.stream().filter(e -> this.contains(e)).count();
    }

    private class MaskEdgeSetNextElementFunctor
    implements PrefetchIterator.NextElementFunctor<E> {
        private Iterator<E> iter;

        public MaskEdgeSetNextElementFunctor() {
            this.iter = MaskEdgeSet.this.edgeSet.iterator();
        }

        @Override
        public E nextElement() throws NoSuchElementException {
            Object edge = this.iter.next();
            while (this.isMasked(edge)) {
                edge = this.iter.next();
            }
            return edge;
        }

        private boolean isMasked(E edge) {
            return MaskEdgeSet.this.mask.isEdgeMasked(edge) || MaskEdgeSet.this.mask.isVertexMasked(MaskEdgeSet.this.graph.getEdgeSource(edge)) || MaskEdgeSet.this.mask.isVertexMasked(MaskEdgeSet.this.graph.getEdgeTarget(edge));
        }
    }
}

