/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Principal;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERString;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.globus.common.CoGProperties;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.bc.X509NameHelper;
import org.globus.gsi.proxy.ext.ProxyCertInfo;
import org.globus.gsi.proxy.ext.ProxyPolicy;
import org.globus.gsi.util.CertificateLoadUtil;
import org.globus.gsi.util.ProxyCertificateUtil;

public final class CertificateUtil {
    public static final int DIGITAL_SIGNATURE = 0;
    public static final int NON_REPUDIATION = 1;
    public static final int KEY_ENCIPHERMENT = 2;
    public static final int DATA_ENCIPHERMENT = 3;
    public static final int KEY_AGREEMENT = 4;
    public static final int KEY_CERTSIGN = 5;
    public static final int CRL_SIGN = 6;
    public static final int ENCIPHER_ONLY = 7;
    public static final int DECIPHER_ONLY = 8;
    public static final int DEFAULT_USAGE_LENGTH = 9;
    private static String provider;
    private static Log logger;

    private CertificateUtil() {
    }

    public static void init() {
        CertificateLoadUtil.init();
    }

    public static void setProvider(String providerName) {
        provider = providerName;
    }

    public static void installSecureRandomProvider() {
        CoGProperties props = CoGProperties.getDefault();
        String providerName = props.getSecureRandomProvider();
        try {
            Class<?> providerClass = Class.forName(providerName);
            Security.insertProviderAt((Provider)providerClass.newInstance(), 1);
        }
        catch (Exception e) {
            logger.debug("Unable to install PRNG. Using default PRNG.", e);
        }
    }

    public static int getCAPathConstraint(TBSCertificateStructure crt) throws IOException {
        X509Extensions extensions = crt.getExtensions();
        if (extensions == null) {
            return -1;
        }
        X509Extension proxyExtension = extensions.getExtension(X509Extensions.BasicConstraints);
        if (proxyExtension != null) {
            BasicConstraints basicExt = CertificateUtil.getBasicConstraints(proxyExtension);
            if (basicExt.isCA()) {
                BigInteger pathLen = basicExt.getPathLenConstraint();
                return pathLen == null ? Integer.MAX_VALUE : pathLen.intValue();
            }
            return -1;
        }
        return -1;
    }

    public static KeyPair generateKeyPair(String algorithm, int bits) throws GeneralSecurityException {
        KeyPairGenerator generator = null;
        generator = provider == null ? KeyPairGenerator.getInstance(algorithm) : KeyPairGenerator.getInstance(algorithm, provider);
        generator.initialize(bits);
        return generator.generateKeyPair();
    }

    public static GSIConstants.CertificateType getCertificateType(TBSCertificateStructure crt) throws CertificateException, IOException {
        BasicConstraints basicExt;
        X509Extensions extensions = crt.getExtensions();
        X509Extension ext = null;
        if (extensions != null && (ext = extensions.getExtension(X509Extensions.BasicConstraints)) != null && (basicExt = CertificateUtil.getBasicConstraints(ext)).isCA()) {
            return GSIConstants.CertificateType.CA;
        }
        GSIConstants.CertificateType type = GSIConstants.CertificateType.EEC;
        X509Name subject = crt.getSubject();
        ASN1Set entry = X509NameHelper.getLastNameEntry(subject);
        ASN1Sequence ava = (ASN1Sequence)entry.getObjectAt(0);
        if (X509Name.CN.equals(ava.getObjectAt(0))) {
            type = CertificateUtil.processCN(extensions, type, ava);
        }
        return type;
    }

    private static GSIConstants.CertificateType processCN(X509Extensions extensions, GSIConstants.CertificateType type, ASN1Sequence ava) throws CertificateException {
        String value = ((DERString)((Object)ava.getObjectAt(1))).getString();
        GSIConstants.CertificateType certType = type;
        if (value.equalsIgnoreCase("proxy")) {
            certType = GSIConstants.CertificateType.GSI_2_PROXY;
        } else if (value.equalsIgnoreCase("limited proxy")) {
            certType = GSIConstants.CertificateType.GSI_2_LIMITED_PROXY;
        } else if (extensions != null) {
            boolean gsi4 = true;
            X509Extension ext = extensions.getExtension(ProxyCertInfo.OID);
            if (ext == null) {
                ext = extensions.getExtension(ProxyCertInfo.OLD_OID);
                gsi4 = false;
            }
            if (ext != null) {
                if (ext.isCritical()) {
                    certType = CertificateUtil.processCriticalExtension(ext, gsi4);
                } else {
                    String err = "proxyCertCritical";
                    throw new CertificateException(err);
                }
            }
        }
        return certType;
    }

    private static GSIConstants.CertificateType processCriticalExtension(X509Extension ext, boolean gsi4) {
        ProxyCertInfo proxyCertExt = ProxyCertificateUtil.getProxyCertInfo(ext);
        ProxyPolicy proxyPolicy = proxyCertExt.getProxyPolicy();
        DERObjectIdentifier oid = proxyPolicy.getPolicyLanguage();
        GSIConstants.CertificateType type = ProxyPolicy.IMPERSONATION.equals(oid) ? (gsi4 ? GSIConstants.CertificateType.GSI_4_IMPERSONATION_PROXY : GSIConstants.CertificateType.GSI_3_IMPERSONATION_PROXY) : (ProxyPolicy.INDEPENDENT.equals(oid) ? (gsi4 ? GSIConstants.CertificateType.GSI_4_INDEPENDENT_PROXY : GSIConstants.CertificateType.GSI_3_INDEPENDENT_PROXY) : (ProxyPolicy.LIMITED.equals(oid) ? (gsi4 ? GSIConstants.CertificateType.GSI_4_LIMITED_PROXY : GSIConstants.CertificateType.GSI_3_LIMITED_PROXY) : (gsi4 ? GSIConstants.CertificateType.GSI_4_RESTRICTED_PROXY : GSIConstants.CertificateType.GSI_3_RESTRICTED_PROXY)));
        return type;
    }

    public static BasicConstraints getBasicConstraints(X509Extension ext) throws IOException {
        ASN1Object object = X509Extension.convertValueToObject(ext);
        return BasicConstraints.getInstance(object);
    }

    public static DERObject toDERObject(byte[] data) throws IOException {
        ByteArrayInputStream inStream = new ByteArrayInputStream(data);
        ASN1InputStream derInputStream = new ASN1InputStream(inStream);
        return derInputStream.readObject();
    }

    public static TBSCertificateStructure getTBSCertificateStructure(X509Certificate cert) throws CertificateEncodingException, IOException {
        DERObject obj = CertificateUtil.toDERObject(cert.getTBSCertificate());
        return TBSCertificateStructure.getInstance(obj);
    }

    public static boolean[] getKeyUsage(TBSCertificateStructure crt) throws IOException {
        X509Extensions extensions = crt.getExtensions();
        if (extensions == null) {
            return new boolean[0];
        }
        X509Extension extension = extensions.getExtension(X509Extensions.KeyUsage);
        return extension != null ? CertificateUtil.getKeyUsage(extension) : new boolean[]{};
    }

    public static boolean[] getKeyUsage(X509Extension ext) throws IOException {
        DERBitString bits = (DERBitString)CertificateUtil.getExtensionObject(ext);
        byte[] bytes = bits.getBytes();
        int length = bytes.length * 8 - bits.getPadBits();
        boolean[] keyUsage = new boolean[length < 9 ? 9 : length];
        for (int i = 0; i != length; ++i) {
            keyUsage[i] = (bytes[i / 8] & 128 >>> i % 8) != 0;
        }
        return keyUsage;
    }

    public static DERObject getExtensionObject(X509Extension ext) throws IOException {
        return CertificateUtil.toDERObject(ext.getValue().getOctets());
    }

    public static String toGlobusID(String dn) {
        return CertificateUtil.toGlobusID(dn, true);
    }

    public static String toGlobusID(String dn, boolean noreverse) {
        if (dn == null) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(dn, ",");
        StringBuffer buf = new StringBuffer();
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (noreverse) {
                buf.append("/");
                buf.append(token);
                continue;
            }
            buf.insert(0, token);
            buf.insert(0, "/");
        }
        return buf.toString();
    }

    public static String toGlobusID(Principal name) {
        if (name instanceof X509Name) {
            return X509NameHelper.toString((X509Name)((Object)name));
        }
        return CertificateUtil.toGlobusID(name.getName());
    }

    public static String toGlobusID(X500Principal principal) {
        if (principal == null) {
            return null;
        }
        String dn = principal.getName();
        StringTokenizer tokens = new StringTokenizer(dn, ",");
        StringBuffer buf = new StringBuffer();
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            buf.insert(0, token);
            buf.insert(0, "/");
        }
        return buf.toString();
    }

    public static X500Principal toPrincipal(String globusID) {
        if (globusID == null) {
            return null;
        }
        String id = globusID.trim();
        StringTokenizer tokens = new StringTokenizer(id, "/");
        StringBuffer buf = new StringBuffer();
        LinkedList<String> rdnList = new LinkedList<String>();
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.contains("=")) {
                rdnList.addFirst(token);
                continue;
            }
            rdnList.set(0, (String)rdnList.get(0) + "/" + token);
        }
        for (String rdn : rdnList) {
            buf.append(",");
            buf.append(rdn);
        }
        if (buf.length() > 0) {
            buf.deleteCharAt(0);
        }
        String dn = buf.toString();
        return new X500Principal(dn);
    }

    public static CertPath getCertPath(X509Certificate[] certs) throws CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        return factory.generateCertPath(Arrays.asList(certs));
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
        CertificateUtil.setProvider("BC");
        logger = LogFactory.getLog(CertificateLoadUtil.class.getCanonicalName());
        CertificateUtil.installSecureRandomProvider();
    }
}

