/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.trustmanager;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStoreException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.X509ProxyCertPathParameters;
import org.globus.gsi.util.CertificateLoadUtil;
import org.globus.gsi.util.CertificateUtil;

public class PKITrustManager
implements X509TrustManager {
    private CertPathValidatorSpi validator;
    private X509ProxyCertPathParameters parameters;
    private CertPathValidatorResult result;
    private Log logger = LogFactory.getLog(this.getClass().getCanonicalName());

    public PKITrustManager(CertPathValidatorSpi initValidator, X509ProxyCertPathParameters initParameters) {
        if (initValidator == null) {
            throw new IllegalArgumentException("Validator cannot be null");
        }
        if (initParameters == null) {
            throw new IllegalArgumentException("Parameter cannot be null");
        }
        this.validator = initValidator;
        this.parameters = initParameters;
    }

    public void checkClientTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        CertPath certPath = CertificateUtil.getCertPath(x509Certificates);
        try {
            this.result = this.validator.engineValidate(certPath, this.parameters);
        }
        catch (CertPathValidatorException exception) {
            throw new CertificateException("Pathvalidation failed", exception);
        }
        catch (InvalidAlgorithmParameterException exception) {
            throw new CertificateException("Pathvalidation failed", exception);
        }
    }

    public void checkServerTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        CertPath certPath = CertificateUtil.getCertPath(x509Certificates);
        try {
            this.result = this.validator.engineValidate(certPath, this.parameters);
        }
        catch (CertPathValidatorException exception) {
            throw new CertificateException("Path validation failed. " + exception.getMessage(), exception);
        }
        catch (InvalidAlgorithmParameterException exception) {
            throw new CertificateException("Path validation failed. " + exception.getMessage(), exception);
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        try {
            Collection<X509Certificate> trusted = CertificateLoadUtil.getTrustedCertificates(this.parameters.getTrustStore(), null);
            return trusted.toArray(new X509Certificate[trusted.size()]);
        }
        catch (KeyStoreException e) {
            this.logger.warn("Unable to load trusted Certificates.  Authentication will fail.", e);
            return new X509Certificate[0];
        }
    }

    public CertPathValidatorResult getValidationResult() {
        return this.result;
    }
}

