/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.trustmanager;

import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.trustmanager.CertificateChecker;
import org.globus.gsi.util.KeyStoreUtil;

public class CRLChecker
implements CertificateChecker {
    private CertStore certStore;
    private KeyStore keyStore;
    private boolean checkDateValidity;

    public CRLChecker(CertStore certStore, KeyStore keyStore, boolean checkDateValidity) {
        this.certStore = certStore;
        this.keyStore = keyStore;
        this.checkDateValidity = checkDateValidity;
    }

    public void invoke(X509Certificate cert, GSIConstants.CertificateType certType) throws CertPathValidatorException {
        Collection<? extends Certificate> caCerts;
        Collection<? extends CRL> crls;
        X500Principal certIssuer = cert.getIssuerX500Principal();
        X509CRLSelector crlSelector = new X509CRLSelector();
        crlSelector.addIssuer(certIssuer);
        try {
            crls = this.certStore.getCRLs(crlSelector);
        }
        catch (CertStoreException e) {
            throw new CertPathValidatorException("Error accessing CRL from certificate store", e);
        }
        if (crls.size() < 1) {
            return;
        }
        X509CertSelector certSelector = new X509CertSelector();
        certSelector.setSubject(certIssuer);
        try {
            caCerts = KeyStoreUtil.getTrustedCertificates(this.keyStore, certSelector);
        }
        catch (KeyStoreException e) {
            throw new CertPathValidatorException("Error accessing CA certificate from certificate store for CRL validation", e);
        }
        if (caCerts.size() < 1) {
            return;
        }
        Certificate caCert = caCerts.iterator().next();
        for (CRL cRL : crls) {
            X509CRL crl = (X509CRL)cRL;
            if (this.checkDateValidity) {
                this.checkCRLDateValidity(crl);
            }
            this.verifyCRL(caCert, crl);
            if (!crl.isRevoked(cert)) continue;
            throw new CertPathValidatorException("Certificate " + cert.getSubjectDN() + " has been revoked");
        }
    }

    private void verifyCRL(Certificate caCert, X509CRL crl) throws CertPathValidatorException {
        try {
            crl.verify(caCert.getPublicKey());
        }
        catch (CRLException e) {
            throw new CertPathValidatorException("Error validating CRL from CA " + crl.getIssuerDN(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertPathValidatorException("Error validating CRL from CA " + crl.getIssuerDN(), e);
        }
        catch (InvalidKeyException e) {
            throw new CertPathValidatorException("Error validating CRL from CA " + crl.getIssuerDN(), e);
        }
        catch (NoSuchProviderException e) {
            throw new CertPathValidatorException("Error validating CRL from CA " + crl.getIssuerDN(), e);
        }
        catch (SignatureException e) {
            throw new CertPathValidatorException("Error validating CRL from CA " + crl.getIssuerDN(), e);
        }
    }

    protected void checkCRLDateValidity(X509CRL crl) throws CertPathValidatorException {
        boolean valid;
        Date now = new Date();
        boolean bl = valid = crl.getThisUpdate().before(now) && crl.getNextUpdate() != null && crl.getNextUpdate().after(now);
        if (!valid) {
            throw new CertPathValidatorException("CRL issued by " + crl.getIssuerDN() + " has expired");
        }
    }
}

