/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.stores;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import org.globus.gsi.stores.AbstractResourceSecurityWrapper;
import org.globus.gsi.stores.ResourceStoreException;
import org.globus.gsi.util.CertificateIOUtil;
import org.globus.gsi.util.CertificateLoadUtil;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceTrustAnchor
extends AbstractResourceSecurityWrapper<TrustAnchor> {
    public ResourceTrustAnchor(String fileName) throws ResourceStoreException {
        this.init(this.resolver.getResource(fileName));
    }

    public ResourceTrustAnchor(Resource resource) throws ResourceStoreException {
        this.init(resource);
    }

    public ResourceTrustAnchor(String fileName, TrustAnchor cachedAnchor) throws ResourceStoreException {
        this.init(this.resolver.getResource(fileName), cachedAnchor);
    }

    public ResourceTrustAnchor(Resource resource, TrustAnchor cachedAnchor) throws ResourceStoreException {
        this.init(resource, cachedAnchor);
    }

    public TrustAnchor getTrustAnchor() throws ResourceStoreException {
        return (TrustAnchor)super.getSecurityObject();
    }

    @Override
    protected TrustAnchor create(Resource resource) throws ResourceStoreException {
        X509Certificate certificate;
        try {
            certificate = CertificateLoadUtil.loadCertificate(resource.getInputStream());
        }
        catch (IOException e) {
            throw new ResourceStoreException(e);
        }
        catch (GeneralSecurityException e) {
            throw new ResourceStoreException(e);
        }
        return new TrustAnchor(certificate, null);
    }

    @Override
    public void store() throws ResourceStoreException {
        try {
            CertificateIOUtil.writeCertificate(this.getTrustAnchor().getTrustedCert(), this.resource.getFile());
        }
        catch (CertificateEncodingException e) {
            throw new ResourceStoreException(e);
        }
        catch (IOException e) {
            throw new ResourceStoreException(e);
        }
    }
}

