/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.jsse;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.jsse.GlobusSSLConfigurationException;
import org.globus.gsi.stores.ResourceCertStoreParameters;

public final class GlobusSSLHelper {
    private GlobusSSLHelper() {
    }

    public static KeyStore buildTrustStore(String provider, String trustAnchorStoreType, String trustAnchorStoreLocation, String trustAnchorStorePassword) throws GlobusSSLConfigurationException {
        try {
            KeyStore trustAnchorStore = provider == null ? KeyStore.getInstance(trustAnchorStoreType) : KeyStore.getInstance(trustAnchorStoreType, provider);
            InputStream keyStoreInput = GlobusSSLHelper.getStream(trustAnchorStoreLocation);
            trustAnchorStore.load(keyStoreInput, trustAnchorStorePassword == null ? null : trustAnchorStorePassword.toCharArray());
            return trustAnchorStore;
        }
        catch (KeyStoreException e) {
            throw new GlobusSSLConfigurationException(e);
        }
        catch (IOException e) {
            throw new GlobusSSLConfigurationException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GlobusSSLConfigurationException(e);
        }
        catch (CertificateException e) {
            throw new GlobusSSLConfigurationException(e);
        }
        catch (NoSuchProviderException e) {
            throw new GlobusSSLConfigurationException(e);
        }
    }

    public static KeyStore findCredentialStore(String provider, String credentialStoreType, String credentialStoreLocation, String credentialStorePassword) throws GlobusSSLConfigurationException {
        try {
            KeyStore credentialStore = provider == null ? KeyStore.getInstance(credentialStoreType) : KeyStore.getInstance(credentialStoreType, provider);
            InputStream keyStoreInput = GlobusSSLHelper.getStream(credentialStoreLocation);
            credentialStore.load(keyStoreInput, credentialStorePassword == null ? null : credentialStorePassword.toCharArray());
            return credentialStore;
        }
        catch (KeyStoreException e) {
            throw new GlobusSSLConfigurationException(e);
        }
        catch (IOException e) {
            throw new GlobusSSLConfigurationException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GlobusSSLConfigurationException(e);
        }
        catch (CertificateException e) {
            throw new GlobusSSLConfigurationException(e);
        }
        catch (NoSuchProviderException e) {
            throw new GlobusSSLConfigurationException(e);
        }
    }

    private static InputStream getStream(String url) throws MalformedURLException, IOException {
        if (url.startsWith("classpath:")) {
            String resource = url.substring(10);
            URL u = ClassLoader.class.getResource(resource);
            if (u == null) {
                throw new MalformedURLException();
            }
            return u.openStream();
        }
        if (url.startsWith("file:")) {
            File f;
            URL u = new URL(url);
            try {
                f = new File(u.toURI());
            }
            catch (URISyntaxException e) {
                f = new File(u.getPath());
            }
            return new FileInputStream(f);
        }
        return new URL(url).openStream();
    }

    public static CertStore findCRLStore(String crlPattern) throws GlobusSSLConfigurationException {
        ResourceCertStoreParameters crlStoreParams = new ResourceCertStoreParameters(null, crlPattern);
        try {
            return CertStore.getInstance("PEMFilebasedCertStore", crlStoreParams);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new GlobusSSLConfigurationException(e);
        }
        catch (NoSuchAlgorithmException e) {
            Log logger = LogFactory.getLog(GlobusSSLHelper.class.getCanonicalName());
            logger.warn("Error Loading CRL store", e);
            throw new GlobusSSLConfigurationException(e);
        }
    }
}

