/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.bc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Security;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.PKCS8EncodedKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKeyStructure;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.globus.gsi.OpenSSLKey;
import org.globus.gsi.bc.BouncyCastleUtil;

public class BouncyCastleOpenSSLKey
extends OpenSSLKey {
    private Log logger = LogFactory.getLog(this.getClass().getCanonicalName());

    public BouncyCastleOpenSSLKey(InputStream is) throws IOException, GeneralSecurityException {
        super(is);
    }

    public BouncyCastleOpenSSLKey(String file) throws IOException, GeneralSecurityException {
        super(file);
    }

    public BouncyCastleOpenSSLKey(PrivateKey key) {
        super(key);
    }

    public BouncyCastleOpenSSLKey(String algorithm, byte[] data) throws GeneralSecurityException {
        super(algorithm, data);
    }

    protected PrivateKey getKey(String alg, byte[] data) throws GeneralSecurityException {
        if (alg.equals("RSA")) {
            try {
                if (data.length == 0) {
                    throw new GeneralSecurityException("Cannot process empty byte stream.");
                }
                ByteArrayInputStream bis = new ByteArrayInputStream(data);
                ASN1InputStream derin = new ASN1InputStream(bis);
                DERObject keyInfo = derin.readObject();
                DERObjectIdentifier rsaOid = PKCSObjectIdentifiers.rsaEncryption;
                AlgorithmIdentifier rsa = new AlgorithmIdentifier(rsaOid);
                PrivateKeyInfo pkeyinfo = new PrivateKeyInfo(rsa, keyInfo);
                DERObject derkey = pkeyinfo.getDERObject();
                byte[] keyData = BouncyCastleUtil.toByteArray(derkey);
                PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyData);
                KeyFactory kfac = KeyFactory.getInstance("RSA");
                return kfac.generatePrivate(spec);
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    protected byte[] getEncoded(PrivateKey key) {
        String format = key.getFormat();
        if (format != null && (format.equalsIgnoreCase("PKCS#8") || format.equalsIgnoreCase("PKCS8"))) {
            try {
                DERObject keyInfo = BouncyCastleUtil.toDERObject(key.getEncoded());
                PrivateKeyInfo pkey = new PrivateKeyInfo((ASN1Sequence)keyInfo);
                DERObject derKey = pkey.getPrivateKey();
                return BouncyCastleUtil.toByteArray(derKey);
            }
            catch (IOException e) {
                this.logger.warn("This shouldn't have happened.", e);
                return new byte[0];
            }
        }
        if (format != null && format.equalsIgnoreCase("PKCS#1") && key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey pKey = (RSAPrivateCrtKey)key;
            RSAPrivateKeyStructure st = new RSAPrivateKeyStructure(pKey.getModulus(), pKey.getPublicExponent(), pKey.getPrivateExponent(), pKey.getPrimeP(), pKey.getPrimeQ(), pKey.getPrimeExponentP(), pKey.getPrimeExponentQ(), pKey.getCrtCoefficient());
            DERObject ob = st.getDERObject();
            try {
                return BouncyCastleUtil.toByteArray(ob);
            }
            catch (IOException e) {
                return new byte[0];
            }
        }
        return new byte[0];
    }

    protected String getProvider() {
        return "BC";
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
    }
}

