/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi;

import java.util.Hashtable;
import java.util.Set;
import org.globus.gsi.X509Extension;
import org.globus.util.I18n;

public class X509ExtensionSet {
    private static I18n i18n = I18n.getI18n("org.globus.gsi.errors", X509ExtensionSet.class.getClassLoader());
    private Hashtable extensions = new Hashtable();

    public X509Extension add(X509Extension extension) {
        if (extension == null) {
            throw new IllegalArgumentException(i18n.getMessage("extensionNull"));
        }
        return this.extensions.put(extension.getOid(), extension);
    }

    public X509Extension get(String oid) {
        if (oid == null) {
            throw new IllegalArgumentException(i18n.getMessage("oidNull"));
        }
        return (X509Extension)this.extensions.get(oid);
    }

    public X509Extension remove(String oid) {
        if (oid == null) {
            throw new IllegalArgumentException(i18n.getMessage("oidNull"));
        }
        return (X509Extension)this.extensions.remove(oid);
    }

    public int size() {
        return this.extensions.size();
    }

    public boolean isEmpty() {
        return this.extensions.isEmpty();
    }

    public void clear() {
        this.extensions.clear();
    }

    public Set oidSet() {
        return this.extensions.keySet();
    }
}

