/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi;

import java.security.Security;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import org.globus.common.CoGProperties;
import org.globus.gsi.TrustedCertificates;
import org.globus.gsi.provider.GlobusProvider;
import org.globus.gsi.provider.simple.SimpleMemoryCertStoreParams;
import org.globus.gsi.provider.simple.SimpleMemoryProvider;
import org.globus.gsi.stores.ResourceCertStoreParameters;

public class TrustedCertificatesUtil {
    public static CertStore createCertStore(TrustedCertificates tc) throws Exception {
        CertStore store = null;
        if (tc == null) {
            String caCertPattern = "file:" + CoGProperties.getDefault().getCaCertLocations() + "/*.0";
            ResourceCertStoreParameters params = new ResourceCertStoreParameters(caCertPattern, null);
            store = CertStore.getInstance("PEMFilebasedCertStore", params);
        } else {
            SimpleMemoryCertStoreParams params = new SimpleMemoryCertStoreParams(tc.getCertificates(), null);
            params.setCerts(tc.getCertificates());
            store = CertStore.getInstance("SimpleMemoryCertStore", (CertStoreParameters)params, "Simple");
        }
        return store;
    }

    static {
        Security.addProvider(new GlobusProvider());
        Security.addProvider(new SimpleMemoryProvider());
    }
}

