/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.storage.common;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.jfrog.storage.common.StorageConstants;

public enum StorageUnit {
    ONE(new BigDecimal(1)){

        @Override
        public double fromBytes(long size) {
            return size;
        }

        @Override
        public double toBytes(int size) {
            return size;
        }

        @Override
        public String displayName() {
            return "bytes";
        }
    }
    ,
    KB(StorageConstants.ONE_KILO){

        @Override
        public double fromBytes(long size) {
            return (double)size / 1024.0;
        }

        @Override
        public double toBytes(int size) {
            return (double)size * 1024.0;
        }
    }
    ,
    MB(KB.getNumberOfBytes().multiply(StorageConstants.ONE_KILO)){

        @Override
        public double fromBytes(long size) {
            return KB.fromBytes(size) / 1024.0;
        }

        @Override
        public double toBytes(int size) {
            return KB.toBytes(size) * 1024.0;
        }
    }
    ,
    GB(MB.getNumberOfBytes().multiply(StorageConstants.ONE_KILO)){

        @Override
        public double fromBytes(long size) {
            return MB.fromBytes(size) / 1024.0;
        }

        @Override
        public double toBytes(int size) {
            return MB.toBytes(size) * 1024.0;
        }
    }
    ,
    TB(GB.getNumberOfBytes().multiply(StorageConstants.ONE_KILO)){

        @Override
        public double fromBytes(long size) {
            return GB.fromBytes(size) / 1024.0;
        }

        @Override
        public double toBytes(int size) {
            return GB.toBytes(size) * 1024.0;
        }
    };

    private final BigDecimal numberOfBytes;

    private StorageUnit(BigDecimal numberOfBytes) {
        this.numberOfBytes = numberOfBytes;
    }

    public BigDecimal getNumberOfBytes() {
        return this.numberOfBytes;
    }

    public abstract double fromBytes(long var1);

    public abstract double toBytes(int var1);

    public String displayName() {
        return this.name();
    }

    public static String toReadableString(long size) {
        DecimalFormat decimalFormat = StorageUnit.createFormat();
        for (StorageUnit unit : StorageUnit.values()) {
            double readableSize = unit.fromBytes(size);
            if (unit == TB) {
                return decimalFormat.format(readableSize) + " " + unit.displayName();
            }
            if (!(readableSize < 1024.0)) continue;
            if (unit == ONE) {
                return size + " " + unit.displayName();
            }
            return decimalFormat.format(readableSize) + " " + unit.displayName();
        }
        throw new IllegalStateException("Could not reach here");
    }

    public static String format(double size) {
        return StorageUnit.createFormat().format(size);
    }

    public static long fromReadableString(String humanReadableSize) {
        String number = humanReadableSize.replaceAll("([TtGgMmKkBb])", "");
        BigDecimal d = new BigDecimal(number);
        BigDecimal l = null;
        int unitLength = humanReadableSize.length() - number.length();
        int unitIndex = unitLength > 0 ? humanReadableSize.length() - unitLength : 0;
        switch (humanReadableSize.charAt(unitIndex)) {
            default: {
                l = d;
                break;
            }
            case 'K': 
            case 'k': {
                l = d.multiply(KB.getNumberOfBytes());
                break;
            }
            case 'M': 
            case 'm': {
                l = d.multiply(MB.getNumberOfBytes());
                break;
            }
            case 'G': 
            case 'g': {
                l = d.multiply(GB.getNumberOfBytes());
                break;
            }
            case 'T': 
            case 't': {
                l = d.multiply(TB.getNumberOfBytes());
            }
        }
        return l.longValue();
    }

    private static DecimalFormat createFormat() {
        DecimalFormat decimalFormat = new DecimalFormat(",###.##", new DecimalFormatSymbols(Locale.ENGLISH));
        decimalFormat.setMinimumFractionDigits(2);
        return decimalFormat;
    }

    public static Long getStorageUnitValue(String parseableLongOrStorageUnitString) {
        try {
            return Long.valueOf(parseableLongOrStorageUnitString);
        }
        catch (NumberFormatException numberFormatException) {
            return StorageUnit.fromReadableString(parseableLongOrStorageUnitString);
        }
    }
}

