/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.storage.binstore.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Checksum {
    private final long length;
    private final MessageDigest digest;
    private String checksum;

    public static Checksum md5() {
        return new Checksum("MD5", 32L);
    }

    public static Checksum sha1() {
        return new Checksum("SHA-1", 40L);
    }

    public static Checksum sha256() {
        return new Checksum("SHA-256", 64L);
    }

    public Checksum(String algorithm, long length) {
        this.length = length;
        try {
            this.digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Cannot create a digest for algorithm: " + algorithm, e);
        }
    }

    public String getAlgorithm() {
        return this.digest.getAlgorithm();
    }

    public long getLength() {
        return this.length;
    }

    public String getChecksum() {
        if (this.checksum == null) {
            throw new IllegalStateException("Checksum not calculated yet.");
        }
        return this.checksum;
    }

    public void reset() {
        this.digest.reset();
    }

    public void update(byte[] bytes, int off, int length) {
        this.digest.update(bytes, off, length);
    }

    public void calc() {
        if (this.checksum != null) {
            throw new IllegalStateException("Checksum already calculated.");
        }
        byte[] bytes = this.digest.digest();
        if ((long)(bytes.length * 2) != this.length) {
            int bitLength = bytes.length * 8;
            throw new IllegalArgumentException("Unrecognised length for binary data: " + bitLength + " bits instead of " + this.length * 4L);
        }
        StringBuilder sb = new StringBuilder();
        for (byte aBinaryData : bytes) {
            String t = Integer.toHexString(aBinaryData & 0xFF);
            if (t.length() == 1) {
                sb.append("0");
            }
            sb.append(t);
        }
        this.checksum = sb.toString().trim();
    }
}

