/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.storage.binstore.ifc;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;

public enum ProviderConnectMode {
    PASS_THROUGH("passThrough"),
    COPY_ON_READ("copyOnRead"),
    COPY_FIRST("copyFirst"),
    MOVE("move");

    private static final Map<String, ProviderConnectMode> CONNECT_MODES;
    public final String propName;

    private ProviderConnectMode(String propName) {
        this.propName = propName;
    }

    @Nonnull
    public static ProviderConnectMode getConnectMode(String propVal) {
        ProviderConnectMode mode;
        if (CONNECT_MODES.isEmpty()) {
            ProviderConnectMode[] values;
            for (ProviderConnectMode value : values = ProviderConnectMode.values()) {
                CONNECT_MODES.put(value.propName, value);
            }
        }
        if ((mode = CONNECT_MODES.get(propVal)) == null) {
            throw new IllegalArgumentException("Connect mode value " + propVal + " is invalid!Choose one of " + CONNECT_MODES.keySet());
        }
        return mode;
    }

    static {
        CONNECT_MODES = Maps.newHashMapWithExpectedSize((int)4);
    }
}

