package org.jfrog.storage.binstore.ifc.model;

/**
 * @author Fred Simon on 12/1/16.
 */
public enum BinaryElementHeaders {
    // Keys:
    // X-Artifactory-Filename, X-Artifactory-Content-Type,
    // X-BinaryProvider-Origin (value artifactoryNodeId.providerId),

    DEEP_SCAN("X-BinaryProvider-DeepScan", "deepScan"),
    LOCAL_ONLY("X-BinaryProvider-LocalOnly", "localOnly"), //Value == providerId?
    SKIP_CACHE("X-BinaryProvider-skipCache", "skipCache"),

    ACTUAL_LENGTH("X-Actual-Length", "actualLength"),
    CHECKSUM_MD5("X-Checksum-Md5", "md5"),
    CHECKSUM_SHA1("X-Checksum-Sha1", "sha1"),
    CHECKSUM_SHA256("X-Checksum-Sha256", "sha2"),

    ARTIFACT_NAME("X-Artifactory-Filename", "filename"),
    CONTENT_TYPE("X-Artifactory-Content-Type", "contentType"),
    USER_NAME("x-jf-subject", "userName"),
    TRACE_ID("x-jf-traceId", "traceId"),
    SIGN_URL_TYPE("X-Artifactory-Sign-Url-Type", "signType");

    private final String headerName;
    private final String fieldName;

    BinaryElementHeaders(String headerName, String fieldName) {
        this.headerName = headerName;
        this.fieldName = fieldName;
    }

    public String getHeaderName() {
        return headerName;
    }

    public String getFieldName() {
        return fieldName;
    }
}
