/*
 * Artifactory is a binaries repository manager.
 * Copyright (C) 2016 JFrog Ltd.
 *
 * Artifactory is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 * Artifactory is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Artifactory.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.jfrog.storage.binstore.ifc;

/**
 * @author gidis
 */
public interface UsageTracking {

    /**
     * Increments the active users of a certain binary to prevent deletion while still in usage.
     *
     * @param sha1 The sha1 checksum to protect
     */
    int incrementNoDeleteLock(String sha1);

    /**
     * Decrements the active users of a certain binary. Indicates that the active usage was ended.
     *
     * @param sha1 The sha1 checksum to remove protection from
     */
    void decrementNoDeleteLock(String sha1);

}
