/*
 * Artifactory is a binaries repository manager.
 * Copyright (C) 2016 JFrog Ltd.
 *
 * Artifactory is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 * Artifactory is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Artifactory.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.jfrog.storage.binstore.ifc;

import org.jfrog.storage.binstore.ifc.model.BinaryElement;

import javax.annotation.Nonnull;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Map;

/**
 * @author Gidi Shabat
 */
public interface BinaryStream extends Closeable {

    @Nonnull
    String getSha1();

    @Nonnull
    String getSha2();

    @Nonnull
    String getMd5();

    BinaryElement getBinaryElement();

    Map<String, String> getHeaders();

    InputStream getStream();

    long getLength();

}
