package org.jfrog.storage.binstore.utils;

import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;

/**
 * @author Dan Feldman
 */
public class BinStoreJacksonUtil {

    private static final ObjectMapper MAPPER = new ObjectMapper() {{
        setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }};

    public static ObjectMapper getObjectMapper() {
        return MAPPER;
    }
}
