package org.jfrog.storage.binstore.ifc;

import java.io.IOException;
import java.io.InputStream;

/**
 * This class allows to differ between exceptions that occurs in input stream and the exceptions
 * that occur in the output stream while copping from input to output
 * The main idea is that we throw special exception in case of read error
 * Example
 * If an exception occur while calling; FileUtils.copyInputStreamToFile(in.getStream(), preFileStoreFile)
 * it is hard to understand what was the cause: writing to file or reading from stream.
 *
 * @author gidis
 */
public class ClientStream extends InputStream {
    private InputStream inputStream;

    public ClientStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public int read() throws IOException {
        try {
            return inputStream.read();
        } catch (Exception e) {
            throw new ClientInputStreamException("Failed to read stream: " + e.getMessage(), e);
        }
    }

    public int read(byte b[]) throws IOException {
        try {
            return inputStream.read(b);
        } catch (Exception e) {
            throw new ClientInputStreamException("Failed to read stream: " + e.getMessage(), e);
        }
    }

    public int read(byte b[], int off, int len) throws IOException {
        try {
            return inputStream.read(b, off, len);
        } catch (Exception e) {
            throw new ClientInputStreamException("Failed to read stream: " + e.getMessage(), e);
        }
    }

    public long skip(long n) throws IOException {
        try {
            return inputStream.skip(n);
        } catch (Exception e) {
            throw new ClientInputStreamException("Failed to skip stream: " + e.getMessage(), e);
        }
    }

    public int available() throws IOException {
        try {
            return inputStream.available();
        } catch (Exception e) {
            throw new ClientInputStreamException("Failed to call available stream: " + e.getMessage(), e);
        }
    }


    public void close() throws IOException {
        try {
            inputStream.close();
        } catch (Exception e) {
            throw new ClientInputStreamException("Failed to close stream: " + e.getMessage(), e);
        }
    }

    public synchronized void mark(int readlimit) {
        inputStream.mark(readlimit);
    }

    public synchronized void reset() throws IOException {
        try {
            inputStream.reset();
        } catch (Exception e) {
            throw new ClientInputStreamException("Failed to reset stream: " + e.getMessage(), e);
        }

    }

    public boolean markSupported() {
        return inputStream.markSupported();
    }

}

