package org.jfrog.storage.binstore.exceptions;

/**
 * @author Dan Feldman
 */
public class BinaryRejectedException extends RuntimeException implements ResponseReadyException {

    private static final int CODE = 409;
    private static final String ERROR = "Mismatch between expected %s: '%s' and actual calculated checksum of this " +
            "stream: '%s'. The Binary is rejected and will not be saved.";

    public BinaryRejectedException(String checksumType, String expectedChecksum, String actualChecksum) {
        super(String.format(ERROR, checksumType, expectedChecksum, actualChecksum));
    }

    @Override
    public int getErrorCode() {
        return CODE;
    }

    @Override
    public String getMessage() {
        return CODE + " : " + super.getMessage();
    }

    @Override
    public String toString() {
        return "BinaryRejectedException: " + getMessage();
    }
}
