/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.security.crypto;

import javax.crypto.spec.IvParameterSpec;
import org.jfrog.security.crypto.exception.CryptoRuntimeException;

public class AesEncryptData {
    private final IvParameterSpec initVector;
    private final byte[] encryptedData;

    public AesEncryptData(IvParameterSpec initVector, byte[] encryptedData) {
        this.initVector = initVector;
        this.encryptedData = encryptedData;
    }

    public AesEncryptData(byte[] compiled) {
        if (compiled == null || compiled.length == 0) {
            throw new NullPointerException("Cannot initialize AES encrypted data with empty compiled byte array");
        }
        byte ivLength = compiled[0];
        if (compiled.length <= 1 + ivLength) {
            throw new CryptoRuntimeException("AES encrypted data received empty data block");
        }
        byte[] iv = new byte[ivLength];
        byte[] data = new byte[compiled.length - 1 - ivLength];
        System.arraycopy(compiled, 1, iv, 0, iv.length);
        System.arraycopy(compiled, 1 + ivLength, data, 0, data.length);
        this.initVector = new IvParameterSpec(iv);
        this.encryptedData = data;
    }

    public IvParameterSpec getInitVector() {
        return this.initVector;
    }

    public byte[] getEncryptedData() {
        return this.encryptedData;
    }

    public byte[] convertToBytes() {
        byte[] iv = this.initVector.getIV();
        if (iv.length >= 127) {
            throw new CryptoRuntimeException("AES init vector too long: " + iv.length);
        }
        byte[] bytes = new byte[1 + iv.length + this.encryptedData.length];
        bytes[0] = (byte)iv.length;
        System.arraycopy(iv, 0, bytes, 1, iv.length);
        System.arraycopy(this.encryptedData, 0, bytes, 1 + iv.length, this.encryptedData.length);
        return bytes;
    }
}

