package org.jfrog.security.crypto.signing.rsa;

import lombok.experimental.UtilityClass;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.signers.RSADigestSigner;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;

/**
 * @author BarakH
 */
@UtilityClass
public class RSASigner {
    private final Logger log = LoggerFactory.getLogger(RSASigner.class);

    public byte[] signDataWithSha1(byte[] dataToSign, PrivateKey privateKey) throws Exception {
        log.debug("Signing data");
        AsymmetricKeyParameter privateKeyAsymKeyParam = PrivateKeyFactory.createKey(privateKey.getEncoded());
        RSADigestSigner signer = new RSADigestSigner(new SHA1Digest());
        signer.init(true, privateKeyAsymKeyParam);
        signer.update(dataToSign, 0, dataToSign.length);
        try {
            return signer.generateSignature();
        } catch (Exception ex) {
            throw new RuntimeException("Cannot generate RSA signature. " + ex.getMessage(), ex);
        }
    }

    public void verifySha1Signature(byte[] signature, byte[] signedData, PublicKey publicKey) throws IOException {
        log.debug("Verifying Signature");
        AsymmetricKeyParameter publicKeyParameter = PublicKeyFactory.createKey(publicKey.getEncoded());
        RSADigestSigner signer = new RSADigestSigner(new SHA1Digest());
        signer.init(false, publicKeyParameter);
        signer.update(signedData, 0, signedData.length);
        if (!signer.verifySignature(signature)) {
            throw new IllegalArgumentException("The sign cannot be verified with the given public key");
        }
    }
}
