package org.jfrog.security.crypto.result;

/**
 * Class represent the status of decryption operation.
 * <p>
 * Currently, the only EncryptionWrapper utilizing the abilities of this class is the
 * {@link org.jfrog.security.crypto.EncryptionWrapper}. In the KeyFileEncryptionWrapper, when the active key file
 * decryption failed, we might fallback and try to decrypt using the other keys in the directory, see
 * {@link org.jfrog.security.crypto.EncryptionWrapperBase#decrypt(String)}. In such a scenario, we must tell the
 * caller that only the fallback keys can decrypt this encrypted data as the caller might want be to re-encrypt the
 * data with the main active key.
 *
 * @author Shay Bagants
 */
public class DecryptionStringResult {
    private String decryptedData;
    private DecryptionStatus status = DecryptionStatus.SUCCESS;

    public DecryptionStringResult(String decryptedData) {
        this(decryptedData, DecryptionStatus.SUCCESS);
    }

    public DecryptionStringResult(String decryptedData, DecryptionStatus status) {
        this.decryptedData = decryptedData;
        this.status = status;
    }

    public String getDecryptedData() {
        return decryptedData;
    }

    public DecryptionStatus getStatus() {
        return status;
    }
}
