/*
 * Copyright (c) 2018. JFrog Ltd. All rights reserved. JFROG PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package org.jfrog.security.crypto.encrypter;

import org.jfrog.security.crypto.exception.CryptoException;

import javax.annotation.Nonnull;

/**
 * @author Saffi Hartal
 */
public abstract class BytesEncrypterBase implements BytesEncrypter {
    protected final String fingerprint;
    protected final String keyId;

    public BytesEncrypterBase(byte[] keyData) {
        try {
            this.fingerprint = BytesEncrypterHelper.getFingerprint(keyData);
            // DO NOT CHANGE KEYID it is used as hint for choosing key to decrypt.
            this.keyId = BytesEncrypterHelper.keyIdFromFingerPrint(fingerprint);
        } catch (CryptoException e) {
            throw new RuntimeException("CryptoException ", e);
        }
    }

    @Nonnull
    @Override
    public String getFingerprint() {
        return fingerprint;
    }

    @Nonnull
    @Override
    public String getKeyId() {
        return keyId;
    }

    /**
     * return if the key matches my keyId.
     */
    public boolean keyMatch(String keyId) {
        return getKeyId().equals(keyId);
    }

    @Override
    public String toString() {
        return "BytesEncrypterBase{" +
                " Cipher='" + getCipherAlg() + '\'' +
                ",  keyId='" + keyId + '\'' +
                '}';
    }
}
