/*
 * Copyright (c) 2018. JFrog Ltd. All rights reserved. JFROG PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package org.jfrog.security.crypto.encrypter;

import org.jfrog.security.crypto.CipherAlg;
import org.jfrog.security.crypto.exception.CryptoException;

import javax.annotation.Nonnull;

public interface BytesEncrypter {
    CipherAlg getCipherAlg();

    /**
     * The keyId used as identifier to match the key with encrypted hint - try or skip that key in decrypt chain.
     * see keyMatch bellow
     *
     * @return the string key id
     */
    @Nonnull
    String getKeyId();

    /**
     * Encrypt method using my secret.
     * The secret was built from the key when/prior construction
     *
     * @param bytes The payload to encrypt
     * @return the encrypted payload
     */
    @Nonnull
    byte[] encrypt(@Nonnull byte[] bytes);

    /**
     * Decrypt the data (using secret )
     */
    // TODO: Should return byte[]
    @Nonnull
    byte[] decrypt(@Nonnull byte[] bytes);

    @Nonnull
    String getFingerprint() throws CryptoException;
}
