/*
 * Copyright (c) 2018. JFrog Ltd. All rights reserved. JFROG PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package org.jfrog.security.crypto.encrypter;

import org.jfrog.security.crypto.AesEncryptData;
import org.jfrog.security.crypto.CipherAlg;
import org.jfrog.security.crypto.JFrogCryptoHelper;
import org.jfrog.security.crypto.SecretProvider;

import javax.annotation.Nonnull;
import javax.crypto.SecretKey;

public class AesBytesEncrypter extends BytesEncrypterBase implements SecretProvider {
    private SecretKey aesKey;

    public AesBytesEncrypter(SecretKey aesKey) {
        super(aesKey.getEncoded());
        this.aesKey = aesKey;
    }

    @Override
    public CipherAlg getCipherAlg() {
        return CipherAlg.AES128;
    }

    @Nonnull
    @Override
    public byte[] encrypt(@Nonnull byte[] bytes) {
        AesEncryptData aesEncryptData = JFrogCryptoHelper.encryptAes(bytes, aesKey);
        return aesEncryptData.convertToBytes();
    }

    @Nonnull
    @Override
    public byte[] decrypt(@Nonnull byte[] bytes) {
        AesEncryptData aesEncryptData = new AesEncryptData(bytes);
        return JFrogCryptoHelper.decryptAes(aesEncryptData, aesKey);
    }

    @Override
    public SecretKey getSecret() {
        return aesKey;
    }
}
