/*
 * Copyright (c) 2017. JFrog Ltd. All rights reserved. JFROG PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */
package org.jfrog.security.crypto;

import org.jfrog.security.crypto.encrypter.BytesEncrypterBase;
import org.jfrog.security.crypto.encrypter.DummyBytesEncrypter;
import org.jfrog.security.crypto.result.DecryptionStringResult;

import javax.annotation.Nonnull;

/**
 * @author Fred Simon on 7/6/16.
 */
public class PlainTextEncryptionWrapper extends EncryptionWrapperBase {
    public PlainTextEncryptionWrapper() {
        super(EncodingType.NO_ENCODING, getEncrypter(), null, FormatUsed.OldFormat);
    }

    @Nonnull
    @Override
    public String encryptIfNeededNoMigrate(@Nonnull String in) {
        return in;
    }

    @Nonnull
    @Override
    public String encryptIfNeeded(@Nonnull String in) {
        return in;
    }

    @Nonnull
    @Override
    public DecryptionStringResult decryptIfNeeded(@Nonnull String in) {
        return new DecryptionStringResult(in);
    }


    @Override
    public boolean isEncodedByMe(@Nonnull String in) {
        return false;
    }

    static private BytesEncrypterBase getEncrypter() {
        return new DummyBytesEncrypter();
    }
}
