/*
 *
 * Artifactory is a binaries repository manager.
 * Copyright (C) 2016 JFrog Ltd.
 *
 * Artifactory is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 * Artifactory is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Artifactory.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.jfrog.security.crypto;

import java.security.KeyPair;
import java.security.PublicKey;

/**
 * @author Fred Simon on 7/5/16.
 */

public class DecodedKeyPair {
    final byte[] privateKey;
    final byte[] publicKey;

    public DecodedKeyPair(byte[] privateKey, byte[] publicKey) {
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public DecodedKeyPair(KeyPair keyPair) {
        privateKey = keyPair.getPrivate().getEncoded();
        publicKey = keyPair.getPublic().getEncoded();
    }

    public boolean hasPrivateKey() {
        return privateKey != null && privateKey.length > 0;
    }

    public KeyPair createKeyPair() {
        return JFrogCryptoHelper.convertToKeyPair(privateKey, publicKey);
    }

    public PublicKey createPublicKey() {
        return JFrogCryptoHelper.convertToPublicKey(publicKey);
    }
}
