/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.security.crypto.signing.gpg;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.iostreams.streams.in.StringInputStream;
import org.jfrog.security.crypto.signing.gpg.PGPKeyParser;
import org.jfrog.security.util.BCProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GpgSigner {
    private static final Logger log = LoggerFactory.getLogger(GpgSigner.class);

    public static String signFile(String privateKey, String password, InputStream content) throws Exception {
        return GpgSigner.signFile(privateKey, password, false, content);
    }

    public static String signFile(String privateKey, String password, boolean includeBeginSignedMessageAndContent, InputStream content) throws Exception {
        try {
            String string;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                PGPSignatureGenerator signatureGenerator = GpgSigner.getPgpSignatureGenerator(privateKey, password);
                GpgSigner.writeSignatureToStream(signatureGenerator, includeBeginSignedMessageAndContent, out, content);
                string = new String(out.toByteArray(), "UTF-8");
            }
            catch (Throwable throwable) {
                try {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new PGPException("Fail to sign file, please verify that there is match between the private key and the passphrase.", e);
                }
            }
            out.close();
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)content);
        }
    }

    public static void signContentAndWriteToOutputStream(OutputStream out, String privateKey, String password, InputStream content) throws Exception {
        try {
            PGPSignatureGenerator signatureGenerator = GpgSigner.getPgpSignatureGenerator(privateKey, password);
            GpgSigner.writeSignatureToStream(signatureGenerator, false, out, content);
        }
        catch (Exception e) {
            throw new PGPException("Fail to sign file, please verify that there is match between the private key and the passphrase.", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)content);
        }
    }

    private static void writeSignatureToStream(PGPSignatureGenerator signatureGenerator, boolean includeBeginSignedMessageAndContent, OutputStream out, InputStream content) throws PGPException, IOException {
        int n;
        ArmoredOutputStream armoredOutput = new ArmoredOutputStream(out);
        if (includeBeginSignedMessageAndContent) {
            armoredOutput.beginClearText(8);
        }
        byte[] buf = new byte[4096];
        while ((n = content.read(buf)) >= 0) {
            signatureGenerator.update(buf, 0, n);
            if (!includeBeginSignedMessageAndContent) continue;
            armoredOutput.write(buf, 0, n);
        }
        if (includeBeginSignedMessageAndContent) {
            armoredOutput.write("\n".getBytes());
        }
        armoredOutput.endClearText();
        PGPSignature signature = signatureGenerator.generate();
        BCPGOutputStream bcpgOutputStream = new BCPGOutputStream((OutputStream)armoredOutput);
        signature.encode((OutputStream)bcpgOutputStream);
        armoredOutput.close();
        bcpgOutputStream.close();
    }

    private static PGPSignatureGenerator getPgpSignatureGenerator(String privateKey, String password) throws PGPException {
        PGPSecretKey pgpSecretKey = PGPKeyParser.findSecretGPGKey(privateKey.getBytes());
        PBESecretKeyDecryptor decryptor = new BcPBESecretKeyDecryptorBuilder((PGPDigestCalculatorProvider)new BcPGPDigestCalculatorProvider()).build(password.toCharArray());
        PGPPrivateKey pgpPrivateKey = pgpSecretKey.extractPrivateKey(decryptor);
        int algorithm = pgpSecretKey.getPublicKey().getAlgorithm();
        PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)new BcPGPContentSignerBuilder(algorithm, 8));
        signatureGenerator.init(0, pgpPrivateKey);
        return signatureGenerator;
    }

    public static boolean verifyFile(String stringPublicKey, String signature, InputStream content) throws Exception {
        try {
            int n;
            PGPSignatureList pgpSigList;
            StringInputStream keyInputStream = new StringInputStream(stringPublicKey);
            InputStream sigInputStream = PGPUtil.getDecoderStream((InputStream)new StringInputStream(signature));
            BcKeyFingerprintCalculator keyFingerPrintCalculator = new BcKeyFingerprintCalculator();
            PGPObjectFactory pgpObjFactory = new PGPObjectFactory(sigInputStream, (KeyFingerPrintCalculator)keyFingerPrintCalculator);
            Object obj = pgpObjFactory.nextObject();
            if (obj instanceof PGPCompressedData) {
                PGPCompressedData c1 = (PGPCompressedData)obj;
                pgpObjFactory = new PGPObjectFactory(c1.getDataStream(), (KeyFingerPrintCalculator)keyFingerPrintCalculator);
                pgpSigList = (PGPSignatureList)pgpObjFactory.nextObject();
            } else {
                pgpSigList = (PGPSignatureList)obj;
            }
            PGPPublicKeyRingCollection pgpPubRingCollection = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)keyInputStream), (KeyFingerPrintCalculator)keyFingerPrintCalculator);
            BufferedInputStream inputStream = new BufferedInputStream(content);
            PGPSignature sig = pgpSigList.get(0);
            PGPPublicKey pubKey = pgpPubRingCollection.getPublicKey(sig.getKeyID());
            BcPGPContentVerifierBuilderProvider pgpContentVerifierBuilderProvider = new BcPGPContentVerifierBuilderProvider();
            sig.init((PGPContentVerifierBuilderProvider)pgpContentVerifierBuilderProvider, pubKey);
            byte[] buf = new byte[4096];
            while ((n = content.read(buf)) >= 0) {
                sig.update(buf, 0, n);
            }
            ((InputStream)inputStream).close();
            keyInputStream.close();
            sigInputStream.close();
            boolean bl = sig.verify();
            return bl;
        }
        catch (Exception e) {
            throw new PGPException("Fail to verify file, please verify that there is match between the public key, signature and the file.", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)content);
        }
    }

    public static boolean verifyPrivateKey(String privateKey) throws Exception {
        try {
            PGPKeyParser.findSecretGPGKey(privateKey.getBytes());
            return true;
        }
        catch (Exception e) {
            log.info("Fail to verify private pgp: {}", (Object)privateKey, (Object)e);
            return true;
        }
    }

    public static boolean verifyPublicKey(String publicKey) throws Exception {
        try {
            StringInputStream keyInputStream = new StringInputStream(publicKey);
            BcKeyFingerprintCalculator keyFingerPrintCalculator = new BcKeyFingerprintCalculator();
            PGPPublicKeyRingCollection pgpPublicKeyRingCollection = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)keyInputStream), (KeyFingerPrintCalculator)keyFingerPrintCalculator);
            return pgpPublicKeyRingCollection.getKeyRings().hasNext();
        }
        catch (Exception e) {
            log.info("Fail to verify public pgp: {}", (Object)publicKey, (Object)e);
            return true;
        }
    }

    static {
        BCProviderFactory.getProvider();
    }
}

