/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.security.crypto;

import java.util.Arrays;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.jfrog.security.crypto.CipherAlg;
import org.jfrog.security.crypto.DotParts;
import org.jfrog.security.crypto.EncodingType;
import org.jfrog.security.crypto.EncryptionWrapper;
import org.jfrog.security.crypto.EncryptionWrapperBase;
import org.jfrog.security.crypto.JFrogBase58;
import org.jfrog.security.crypto.JFrogCryptoHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JFrogEnvelop {
    private static final Logger log = LoggerFactory.getLogger(JFrogEnvelop.class);
    public final EncodingType encodingType;
    private final DotParts parts;

    public JFrogEnvelop(@Nonnull EncodingType encodingType, @Nonnull DotParts parts) {
        this.encodingType = encodingType;
        this.parts = parts;
    }

    @Nullable
    public CipherAlg getAlg() {
        return this.parts.getAlg();
    }

    public String getKeyId() {
        return this.parts.getKeyId();
    }

    public boolean isGoodChecksum() {
        byte[] data = this.parts.getPayload();
        return JFrogBase58.isGoodChecksum(data);
    }

    public byte[] extractBytes() {
        byte[] data = this.parts.getPayload();
        if (!JFrogBase58.isGoodChecksum(data)) {
            log.warn("Received input string '" + JFrogCryptoHelper.debugMessageForSensitiveStrings(this.parts.input) + "' with wrong checksum of last 2 bytes");
            return null;
        }
        return Arrays.copyOfRange(data, 0, data.length - 2);
    }

    public static String encode(@Nonnull EncodingType et, @Nullable String keyId, @Nullable CipherAlg alg, @Nonnull byte[] bytes) {
        if (alg == null) {
            if (StringUtils.isBlank((String)keyId)) {
                return et.encode(bytes);
            }
            log.warn("keyId {} while not alg specified", (Object)keyId);
            alg = CipherAlg.DESede;
        } else if (keyId == null) {
            keyId = "";
        }
        return et.encodeFormat(keyId, alg, bytes);
    }

    public String encode() {
        byte[] bytes;
        String keyId = this.getKeyId();
        if (keyId == null) {
            keyId = "";
        }
        if ((bytes = this.extractBytes()) == null) {
            return null;
        }
        return JFrogEnvelop.encode(this.encodingType, keyId, this.getAlg(), bytes);
    }

    @Nonnull
    public CipherAlg getAlgOrDefault(EncryptionWrapper wrapper) {
        CipherAlg res = this.getAlg();
        if (res == null) {
            return ((EncryptionWrapperBase)wrapper).topEncrypter.getCipherAlg();
        }
        return res;
    }

    @Nullable
    public static JFrogEnvelop parse(String st) {
        if (st != null) {
            st = st.trim();
        }
        return JFrogEnvelop.parse(st, it -> {});
    }

    public static JFrogEnvelop parse(String st, Consumer<String> onFail) {
        DotParts parts = EncodingType.takeDotParts(st);
        EncodingType encodingType = EncodingType.findEncodedBy(parts);
        if (encodingType == null) {
            if (!StringUtils.isBlank((String)st)) {
                onFail.accept(JFrogEnvelop.substrSafe(st, 0, 4));
            }
            return null;
        }
        return new JFrogEnvelop(encodingType, parts);
    }

    private static String substrSafe(String st, int offset, int limit) {
        if (st == null) {
            return "empty";
        }
        return st.substring(offset, Math.min(st.length(), offset + limit));
    }

    public String toString() {
        String algString = this.parts.getAlgString();
        if (algString == null) {
            algString = "null";
        }
        return "JFrogEnvelop{encodingType=" + this.encodingType + ", parts=" + this.parts.toString() + "}";
    }
}

