/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.security.crypto;

import org.apache.commons.lang.StringUtils;
import org.jfrog.security.crypto.DecodedKeyPair;
import org.jfrog.security.crypto.EncodingType;
import org.jfrog.security.crypto.EncryptionWrapper;
import org.jfrog.security.crypto.EncryptionWrapperBase;
import org.jfrog.security.crypto.JFrogCryptoHelper;
import org.jfrog.security.crypto.JFrogEnvelop;
import org.jfrog.security.crypto.result.DecryptionBytesResult;
import org.jfrog.security.crypto.result.DecryptionStatus;
import org.jfrog.security.crypto.result.DecryptionStatusHolder;

public class EncodedKeyPair {
    public static final String NO_PRIVATE_KEY = "NO PRIVATE KEY";
    public final String encodedPrivateKey;
    public final String encodedPublicKey;

    public EncodedKeyPair(String encodedPublicKey) {
        this(NO_PRIVATE_KEY, encodedPublicKey);
    }

    public EncodedKeyPair(String encodedPrivateKey, String encodedPublicKey) {
        if (encodedPublicKey == null) {
            throw new IllegalArgumentException("Public key cannot be null");
        }
        this.encodedPrivateKey = encodedPrivateKey == null ? NO_PRIVATE_KEY : encodedPrivateKey.trim();
        this.encodedPublicKey = encodedPublicKey.trim();
    }

    public EncodedKeyPair(DecodedKeyPair decodedKeyPair, EncryptionWrapper keyWrapper) {
        if (keyWrapper == null || keyWrapper.getEncodingType() == EncodingType.NO_ENCODING) {
            this.encodedPrivateKey = decodedKeyPair.hasPrivateKey() ? EncodingType.SAVED_PRIVATE_KEY.encode(decodedKeyPair.privateKey) : NO_PRIVATE_KEY;
            this.encodedPublicKey = EncodingType.SAVED_PUBLIC_KEY.encode(decodedKeyPair.publicKey);
        } else {
            this.encodedPrivateKey = decodedKeyPair.hasPrivateKey() ? EncodingType.ARTIFACTORY_PRIVATE_KEY.encode(keyWrapper.encrypt(decodedKeyPair.privateKey)) : NO_PRIVATE_KEY;
            this.encodedPublicKey = EncodingType.ARTIFACTORY_PUBLIC_KEY.encode(keyWrapper.encrypt(decodedKeyPair.publicKey));
        }
        if (this.encodedPublicKey == null) {
            throw new IllegalArgumentException("Public key cannot be null");
        }
    }

    public boolean hasPrivateKey() {
        return StringUtils.isNotBlank((String)this.encodedPrivateKey) && !NO_PRIVATE_KEY.equals(this.encodedPrivateKey);
    }

    public String getEncodedPrivateKey() {
        return this.encodedPrivateKey;
    }

    public String getEncodedPublicKey() {
        return this.encodedPublicKey;
    }

    public DecodedKeyPair decode(EncryptionWrapper masterWrapper, DecryptionStatusHolder statusHolder) {
        EncodingTypes encodingTypes = new EncodingTypes();
        byte[] privateKeyBytes = null;
        EncodingType publicEncodedBy = EncodedKeyPair.validPublicEncodedKey(this.encodedPublicKey);
        byte[] publicKeyBytes = publicEncodedBy.decode(this.encodedPublicKey);
        if (masterWrapper == null || masterWrapper.getEncodingType() == EncodingType.NO_ENCODING) {
            return this.asPlainTextDecodedKeyPair(encodingTypes, publicKeyBytes);
        }
        EncryptionWrapperBase multiForFallbackCheck = (EncryptionWrapperBase)masterWrapper;
        if (this.hasPrivateKey()) {
            privateKeyBytes = encodingTypes.privateEncodedBy.decode(this.encodedPrivateKey);
            if (encodingTypes.privateEncodedBy == EncodingType.ARTIFACTORY_PRIVATE_KEY) {
                String encodedPrivateKey = this.encodedPrivateKey;
                DecryptionBytesResult privateKeyDecryptionResult = this.decryptKey(multiForFallbackCheck, encodedPrivateKey, statusHolder);
                privateKeyBytes = privateKeyDecryptionResult.getDecryptedData();
            }
        }
        if (encodingTypes.publicEncodedBy == EncodingType.ARTIFACTORY_PUBLIC_KEY) {
            String encodedPublicKey = this.encodedPublicKey;
            DecryptionBytesResult publicKeyDecryptionResult = this.decryptKey(multiForFallbackCheck, encodedPublicKey, statusHolder);
            publicKeyBytes = publicKeyDecryptionResult.getDecryptedData();
        }
        return new DecodedKeyPair(privateKeyBytes, publicKeyBytes);
    }

    private DecryptionBytesResult decryptKey(EncryptionWrapperBase encrypterWrapper, String encodedKey, DecryptionStatusHolder statusHolder) {
        JFrogEnvelop jfe = JFrogEnvelop.parse(encodedKey);
        DecryptionBytesResult decryptionResult = encrypterWrapper.decrypt(jfe.extractBytes());
        if (DecryptionStatus.SUCCESS_WITH_FALLBACK.equals((Object)decryptionResult.getStatus())) {
            statusHolder.addSuccessWithFallback();
        }
        return decryptionResult;
    }

    private DecodedKeyPair asPlainTextDecodedKeyPair(EncodingTypes encodingTypes, byte[] publicKeyBytes) {
        if (this.needsMasterWrapper(encodingTypes)) {
            throw new IllegalStateException("Cannot decode encrypted key pair without master wrapper for " + this.toString());
        }
        byte[] privateKeyBytes = null;
        if (this.hasPrivateKey()) {
            privateKeyBytes = encodingTypes.privateEncodedBy.decode(this.encodedPrivateKey);
        }
        return new DecodedKeyPair(privateKeyBytes, publicKeyBytes);
    }

    private boolean needsMasterWrapper(EncodingTypes encodedBy) {
        return encodedBy.privateEncodedBy == EncodingType.ARTIFACTORY_PRIVATE_KEY || encodedBy.publicEncodedBy == EncodingType.ARTIFACTORY_PUBLIC_KEY;
    }

    public EncodedKeyPair toSaveEncodedKeyPair(EncryptionWrapper artifactoryKeyWrapper) {
        EncodingType privateEncodedBy = null;
        if (this.hasPrivateKey()) {
            privateEncodedBy = EncodedKeyPair.validPrivateEncodedKey(this.encodedPrivateKey);
        }
        EncodingType publicEncodedBy = EncodedKeyPair.validPublicEncodedKey(this.encodedPublicKey);
        if (privateEncodedBy == EncodingType.ARTIFACTORY_MASTER || publicEncodedBy == EncodingType.ARTIFACTORY_MASTER) {
            return new EncodedKeyPair(this.decode(artifactoryKeyWrapper, new DecryptionStatusHolder()), artifactoryKeyWrapper);
        }
        return null;
    }

    private static EncodingType validPrivateEncodedKey(String privateKey) {
        EncodingType privateEncodedBy = EncodingType.findEncodedBy(privateKey);
        if (privateEncodedBy == null || privateEncodedBy != EncodingType.ARTIFACTORY_MASTER && privateEncodedBy != EncodingType.SAVED_PRIVATE_KEY && privateEncodedBy != EncodingType.ARTIFACTORY_PRIVATE_KEY) {
            throw new IllegalStateException("Illegal private key encoding " + privateEncodedBy + " for " + JFrogCryptoHelper.debugMessageForSensitiveStrings(privateKey));
        }
        return privateEncodedBy;
    }

    private static EncodingType validPublicEncodedKey(String publicKey) {
        EncodingType publicEncodedBy = EncodingType.findEncodedBy(publicKey);
        if (publicEncodedBy == null || publicEncodedBy != EncodingType.ARTIFACTORY_MASTER && publicEncodedBy != EncodingType.SAVED_PUBLIC_KEY && publicEncodedBy != EncodingType.ARTIFACTORY_PUBLIC_KEY) {
            throw new IllegalStateException("Illegal public key encoding " + publicEncodedBy + " for " + JFrogCryptoHelper.debugMessageForSensitiveStrings(publicKey));
        }
        return publicEncodedBy;
    }

    public String toString() {
        return "Encoded key " + JFrogCryptoHelper.debugMessageForSensitiveStrings(this.encodedPrivateKey, this.encodedPublicKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncodedKeyPair that = (EncodedKeyPair)o;
        if (this.encodedPrivateKey != null ? !this.encodedPrivateKey.equals(that.encodedPrivateKey) : that.encodedPrivateKey != null) {
            return false;
        }
        return this.encodedPublicKey.equals(that.encodedPublicKey);
    }

    public int hashCode() {
        int result = this.encodedPrivateKey != null ? this.encodedPrivateKey.hashCode() : 0;
        result = 31 * result + this.encodedPublicKey.hashCode();
        return result;
    }

    class EncodingTypes {
        final EncodingType privateEncodedBy;
        final EncodingType publicEncodedBy;

        public EncodingTypes() {
            this.privateEncodedBy = EncodedKeyPair.this.hasPrivateKey() ? EncodedKeyPair.validPrivateEncodedKey(EncodedKeyPair.this.encodedPrivateKey) : null;
            this.publicEncodedBy = EncodedKeyPair.validPublicEncodedKey(EncodedKeyPair.this.encodedPublicKey);
        }
    }
}

