package org.jfrog.security.util;

import org.bouncycastle.jce.provider.BouncyCastleProvider;

import java.security.Security;

/**
 * @author Yinon Avraham.
 */
public class BCProviderFactory {

    // The BC provider is configurable so we keep our own instance (to encapsulate it and not allow configuration
    // changes by others), but except for the configurability it is thread safe so we can keep it static.
    // We prefer to use a static field (instead of an instance field) because the provider is registered in an
    // IdentityHashMap in the JceSecurity when a SecurityKeyFactory is requested.
    private static final BouncyCastleProvider BC_PROVIDER = new BouncyCastleProvider();

    static {
        Security.addProvider(BC_PROVIDER);
    }

    public static BouncyCastleProvider getProvider() {
        return BC_PROVIDER;
    }
}
