package org.jfrog.security.crypto.signing.gpg;

import javax.annotation.Nonnull;
import java.security.PrivateKey;

/**
 * Created by tomerm on 20.7.17.
 */
public class WrappedPrivateKey {

    private PrivateKey privateKey;
    private String kid;
    private String algorithmName;

    /**
     * A Private Key Wrapper Object
     *
     * @param privateKey the wrapped private key
     * @param kid a sha256hex representation of the public key
     * @param algorithmName the exact algorithm name (supports ECDSA only for now)
     */
    public WrappedPrivateKey(PrivateKey privateKey, String kid, @Nonnull String algorithmName) {
        this.privateKey = privateKey;
        this.kid = kid;
        this.algorithmName = algorithmName;
    }

    public PrivateKey getPrivateKey() {
        return privateKey;
    }

    public String getKid() {
        return kid;
    }

    public String getAlgorithmName() {
        return algorithmName;
    }

}
