package org.jfrog.security.crypto.result;

/**
 * Class represent a status of key file chain decryption operation.
 * <p>
 * When the active key file decryption failed, we fallback and try to decrypt using the other keys in the directory. In
 * such a scenario, we must tell the caller that only the fallback keys can decrypt this encrypted data, so the caller
 * should be responsible to re-encrypt the data with the correct key to avoid inconsistent state.
 *
 * @author Shay Bagants
 */
public class DecryptionBytesResult {
    private byte[] decryptedData;
    private DecryptionStatus status = DecryptionStatus.SUCCESS;

    public DecryptionBytesResult(byte[] bytes) {
        this(bytes, DecryptionStatus.SUCCESS);
    }

    public DecryptionBytesResult(byte[] bytes, DecryptionStatus status) {
        this.decryptedData = bytes;
        this.status = status;
    }

    public byte[] getDecryptedData() {
        return decryptedData;
    }

    public DecryptionStatus getStatus() {
        return status;
    }
}
