/*
 * Copyright (c) 2018. JFrog Ltd. All rights reserved. JFROG PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package org.jfrog.security.crypto.encrypter;

import org.jfrog.security.crypto.CipherAlg;

import javax.annotation.Nonnull;

public class DummyBytesEncrypter extends BytesEncrypterBase {

    private static final String DUMMY_KEY = "dummy";

    public DummyBytesEncrypter() {
        super(DUMMY_KEY.getBytes());
    }

    @Override
    public CipherAlg getCipherAlg() {
        return CipherAlg.DUMMY;
    }

    @Nonnull
    @Override
    public String getKeyId() {
        return DUMMY_KEY;
    }

    @Nonnull
    @Override
    public byte[] encrypt(@Nonnull byte[] bytes) {
        return bytes;
    }

    @Nonnull
    @Override
    public byte[] decrypt(@Nonnull byte[] bytes) {
        return bytes;
    }
}
