/*
 * Copyright (c) 2017. JFrog Ltd. All rights reserved. JFROG PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package org.jfrog.security.crypto;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Saffi Hartal 18-01-24
 * class used for parsing new DotFormat with embeeded
 */
class JFrogHintedBase58Parser {
    private static final Logger log = LoggerFactory.getLogger(JFrogHintedBase58Parser.class);

    static boolean isBase58(String data, int fromOffset) {
        if ((data == null) || (fromOffset<0)) {
            return false;
        }
        for (int i = fromOffset; i < data.length(); i++) {
            if (!JFrogBase58.alphabetSet.contains(data.charAt(i))) {
                return false;
            }
        }
        return true;
    }

    public static DotParts parse(String input, int offset) {
        DotParts res = new DotParts(input, offset);
        if (!res.isBase58Data()){
            return null;
        }
        return res;
    }
    public static String build(String markers, String keyId, CipherAlg alg, byte[] payload){
        return String.format("%s.%s.%s.%s", "" + markers,
                keyId,
                alg.name(),
                JFrogBase58.encode(payload));
    }


     static int findDelim(String chars, int offset) {
        if (offset < 0) {
            return offset; // -1
        }
        if (chars==null){
            return -1;
        }
        return chars.indexOf(".", offset);
    }


}
