/*
 * Copyright (c) 2018. JFrog Ltd. All rights reserved. JFROG PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package org.jfrog.security.crypto;

import javax.annotation.Nullable;

/**
 * Parse string Dot delimited that Either has no Dot .
 * OR start with a Dot.  having additional two fields keyid alg payload
 */
public class DotParts {
    final public String input;
    final public int offset;
    private final static int LEN = 5;
    private final static int PAYLOAD_CELL = 0;
    private final static int ALG_CELL = 1;
    private final static int KEYID_CELL = 2;
    private final static int REST_CELL = 3;
    private int[] dots = new int[LEN];
    DotParts(String input, int offset) {
        this.input = input;

        dotParse(dots, input, offset);
        this.offset=offset;
    }

    static void dotParse(int arr[], String input, int offset) {
        for(int i=0;i<arr.length; i++){
            arr[i] = -1;
        }
        if ((input==null) || (offset>=input.length())) return;
        arr[0] = offset; // case not dots.
        int idx = input.length();
        int i;
        for(i = 0; i < LEN; i++){
            idx = input.lastIndexOf('.', idx - 1);
            if (idx >= offset) {
                arr[i] = idx+1; // start of field
            } else {
                arr[i] = offset;
                break;
            }
        }
        if (arr[REST_CELL]>offset){
            // too many dots.
            for(i=0;i<arr.length; i++){
                arr[i] = -1;
            }
        }
    }

    byte[] getPayload() {
        int idx = getDataOffset();
        if (idx<0) return null;
        return JFrogBase58.decode(input, idx);
    }

    private int getDataOffset() {
        return dots[PAYLOAD_CELL];
    }

    @Nullable public String getKeyId() {
        int idx = dots[KEYID_CELL];
        int till = dots[KEYID_CELL-1]-1;
        if (idx<0) return null;
        return input.substring(idx, till);
    }

    @Nullable
    String getAlgString() {
        int idx = dots[ALG_CELL];
        int till = dots[ALG_CELL-1]-1;
        if (idx<0) return null;
        return input.substring(idx, till);
    }


    @Nullable
    CipherAlg getAlg() {
        String algString = getAlgString();
        // This case is the old default algorithm
        if (algString == null) {
            return null;
        }
        return CipherAlg.valueOf(algString);
    }
    @Override
    public String toString() {
        return JFrogCryptoHelper.debugMessageForSensitiveStrings(input);
    }
    boolean isBase58Data(){

        return JFrogHintedBase58Parser.isBase58(input, getDataOffset());
    }
}
