/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.security.ssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import javax.security.auth.x500.X500Principal;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.X509Certificate;
import org.apache.commons.codec.digest.DigestUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.x509.extension.X509ExtensionUtil;
import org.jfrog.security.ssl.CertificateGenerationException;
import org.jfrog.security.util.BCProviderFactory;

public abstract class CertificateHelper {
    public static final ASN1ObjectIdentifier CERT_VERSION_OID = new ASN1ObjectIdentifier("2.5.29.17.1").intern();
    private static final String SIG_ALG = "SHA256WithRSA";
    private static final String BC_PROVIDER = "BC";
    private static final long ONE_DAY_IN_MS = 86400000L;
    private static final long MAX_EXPIRY;

    private CertificateHelper() {
    }

    public static X509Certificate generateSignedCertificate(X500Principal issuer, PrivateKey issuerPrivateKey, X500Principal subject, PublicKey subjectPublicKey, BigInteger serialNumber, long expireIn) throws CertificateGenerationException {
        return CertificateHelper.generateSignedCertificate(issuer, issuerPrivateKey, subject, subjectPublicKey, serialNumber, expireIn, false, 0);
    }

    public static X509Certificate generateSignedCertificate(X500Principal issuer, PrivateKey issuerPrivateKey, X500Principal subject, PublicKey subjectPublicKey, BigInteger serialNumber, long expireIn, boolean addSubAltNames, int certVersion) throws CertificateGenerationException {
        try {
            Date startDate = new Date(System.currentTimeMillis() - 86400000L);
            if (expireIn < 0L) {
                throw new IllegalArgumentException("'expire in' must be a positive number");
            }
            long endMillis = System.currentTimeMillis() + expireIn;
            endMillis = endMillis < 0L || endMillis > MAX_EXPIRY ? MAX_EXPIRY : endMillis;
            Date endDate = new Date(endMillis);
            X509v3CertificateBuilder builder = new X509v3CertificateBuilder(X500Name.getInstance((Object)issuer.getEncoded()), serialNumber, startDate, endDate, X500Name.getInstance((Object)subject.getEncoded()), SubjectPublicKeyInfo.getInstance((Object)new ASN1InputStream(subjectPublicKey.getEncoded()).readObject()));
            if (addSubAltNames) {
                CertificateHelper.setSubAltNames(subject, builder);
            }
            CertificateHelper.addCertificateVersion(builder, certVersion);
            ContentSigner sigGen = new JcaContentSignerBuilder(SIG_ALG).setProvider(BC_PROVIDER).build(issuerPrivateKey);
            X509CertificateHolder certHolder = builder.build(sigGen);
            return X509Certificate.getInstance(certHolder.getEncoded());
        }
        catch (Exception e) {
            throw new CertificateGenerationException("Failed to generate signed certificate: " + e.getMessage(), e);
        }
    }

    public static int getCertificateVersion(java.security.cert.X509Certificate certificate) throws IOException {
        byte[] version = certificate.getExtensionValue(CERT_VERSION_OID.getId());
        if (version != null) {
            GeneralName[] names;
            Integer versionFromCertificate = null;
            GeneralNames gn = GeneralNames.getInstance((Object)X509ExtensionUtil.fromExtensionValue((byte[])version));
            for (GeneralName name : names = gn.getNames()) {
                if (name.getTagNo() != 0) continue;
                ASN1Sequence seq = ASN1Sequence.getInstance((Object)name.getName());
                ASN1Integer value = (ASN1Integer)seq.getObjectAt(1);
                versionFromCertificate = value.getValue().intValue();
            }
            return versionFromCertificate;
        }
        return 0;
    }

    public static java.security.cert.X509Certificate generateRootX509Certificate(KeyPair keyPair, String commonName, boolean addSubAltNames, int certVersion) throws CertificateGenerationException {
        X509Certificate cert = CertificateHelper.generateRootCertificate(keyPair, commonName, addSubAltNames, certVersion);
        return CertificateHelper.convert(cert);
    }

    public static X509Certificate generateRootCertificate(KeyPair keyPair, String commonName, boolean addSubAltNames, int certVersion) throws CertificateGenerationException {
        BigInteger serialNumber = CertificateHelper.randomSerialNumber();
        X500Principal accessPrincipal = new X500Principal("CN=" + commonName);
        return CertificateHelper.generateSignedCertificate(accessPrincipal, keyPair.getPrivate(), accessPrincipal, keyPair.getPublic(), serialNumber, Long.MAX_VALUE, addSubAltNames, certVersion);
    }

    public static java.security.cert.X509Certificate convert(X509Certificate cert) {
        try {
            byte[] encoded = cert.getEncoded();
            ByteArrayInputStream bis = new ByteArrayInputStream(encoded);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            return (java.security.cert.X509Certificate)cf.generateCertificate(bis);
        }
        catch (java.security.cert.CertificateEncodingException certificateEncodingException) {
        }
        catch (CertificateEncodingException certificateEncodingException) {
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        return null;
    }

    private static BigInteger randomSerialNumber() {
        UUID uuid = UUID.randomUUID();
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return new BigInteger(1, bb.array());
    }

    private static String addSchema(String subjectName) {
        return "http://" + subjectName;
    }

    private static void setSubAltNames(X500Principal subject, X509v3CertificateBuilder builder) throws CertIOException {
        String[] serverId = subject.getName().split("@");
        if (serverId.length == 2) {
            String parsedSubjAltName = serverId[1];
            GeneralName altName = new GeneralName(2, parsedSubjAltName);
            GeneralNames subjectAltName = new GeneralNames(altName);
            builder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAltName);
        }
    }

    private static void addCertificateVersion(X509v3CertificateBuilder builder, int version) throws CertIOException {
        DERSequence seq = new DERSequence(new ASN1Encodable[]{CERT_VERSION_OID, new ASN1Integer((long)version)});
        ArrayList<GeneralName> namesList = new ArrayList<GeneralName>();
        namesList.add(new GeneralName(0, (ASN1Encodable)seq));
        GeneralNames versionName = GeneralNames.getInstance((Object)new DERSequence((ASN1Encodable[])namesList.toArray(new GeneralName[0])));
        builder.addExtension(CERT_VERSION_OID, false, (ASN1Encodable)versionName);
    }

    public static String getCertificateIssuerCommonName(java.security.cert.X509Certificate certificate) throws java.security.cert.CertificateEncodingException {
        RDN commonName;
        String result = "Unknown";
        JcaX509CertificateHolder certificateHolder = new JcaX509CertificateHolder(certificate);
        RDN[] rdNs = certificateHolder.getIssuer().getRDNs(BCStyle.CN);
        if (rdNs != null && rdNs.length > 0 && (commonName = rdNs[0]).getFirst() != null && commonName.getFirst().getValue() != null) {
            result = IETFUtils.valueToString((ASN1Encodable)commonName.getFirst().getValue());
        }
        return result;
    }

    public static String getCertificateIssuerOrganizationUnit(java.security.cert.X509Certificate certificate) throws java.security.cert.CertificateEncodingException {
        RDN organizationUnit;
        String result = "Unknown";
        JcaX509CertificateHolder certificateHolder = new JcaX509CertificateHolder(certificate);
        RDN[] rdNs = certificateHolder.getIssuer().getRDNs(BCStyle.OU);
        if (rdNs != null && rdNs.length > 0 && (organizationUnit = rdNs[0]).getFirst() != null && organizationUnit.getFirst().getValue() != null) {
            result = IETFUtils.valueToString((ASN1Encodable)organizationUnit.getFirst().getValue());
        }
        return result;
    }

    public static String getCertificateIssuerOrganization(java.security.cert.X509Certificate certificate) throws java.security.cert.CertificateEncodingException {
        RDN organization;
        String result = "Unknown";
        JcaX509CertificateHolder certificateHolder = new JcaX509CertificateHolder(certificate);
        RDN[] rdNs = certificateHolder.getIssuer().getRDNs(BCStyle.O);
        if (rdNs != null && rdNs.length > 0 && (organization = rdNs[0]).getFirst() != null && organization.getFirst().getValue() != null) {
            result = IETFUtils.valueToString((ASN1Encodable)organization.getFirst().getValue());
        }
        return result;
    }

    public static String getCertificateSubjectCommonName(java.security.cert.X509Certificate certificate) throws java.security.cert.CertificateEncodingException {
        RDN commonName;
        String result = "Unknown";
        JcaX509CertificateHolder certificateHolder = new JcaX509CertificateHolder(certificate);
        RDN[] rdNs = certificateHolder.getSubject().getRDNs(BCStyle.CN);
        if (rdNs != null && rdNs.length > 0 && (commonName = rdNs[0]).getFirst() != null && commonName.getFirst().getValue() != null) {
            result = IETFUtils.valueToString((ASN1Encodable)commonName.getFirst().getValue());
        }
        return result;
    }

    public static String getCertificateSubjectOrganizationUnit(java.security.cert.X509Certificate certificate) throws java.security.cert.CertificateEncodingException {
        RDN organizationUnit;
        String result = "Unknown";
        JcaX509CertificateHolder certificateHolder = new JcaX509CertificateHolder(certificate);
        RDN[] rdNs = certificateHolder.getSubject().getRDNs(BCStyle.OU);
        if (rdNs != null && rdNs.length > 0 && (organizationUnit = rdNs[0]).getFirst() != null && organizationUnit.getFirst().getValue() != null) {
            result = IETFUtils.valueToString((ASN1Encodable)organizationUnit.getFirst().getValue());
        }
        return result;
    }

    public static String getCertificateSubjectOrganization(java.security.cert.X509Certificate certificate) throws java.security.cert.CertificateEncodingException {
        RDN organization;
        String result = "Unknown";
        JcaX509CertificateHolder certificateHolder = new JcaX509CertificateHolder(certificate);
        RDN[] rdNs = certificateHolder.getSubject().getRDNs(BCStyle.O);
        if (rdNs != null && rdNs.length > 0 && (organization = rdNs[0]).getFirst() != null && organization.getFirst().getValue() != null) {
            result = IETFUtils.valueToString((ASN1Encodable)organization.getFirst().getValue());
        }
        return result;
    }

    public static Date getValidUntil(java.security.cert.X509Certificate certificate) {
        return certificate.getNotAfter();
    }

    public static Date getIssuedAt(java.security.cert.X509Certificate certificate) {
        return certificate.getNotBefore();
    }

    public static String getCertificateFingerprint(java.security.cert.X509Certificate certificate) throws java.security.cert.CertificateEncodingException {
        byte[] bytes = DigestUtils.sha256((byte[])certificate.getEncoded());
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String appendString = Integer.toHexString(0xFF & bytes[i]);
            if (appendString.length() == 1) {
                builder.append("0");
            }
            builder.append(appendString.toUpperCase());
            if (i == bytes.length - 1) continue;
            builder.append(':');
        }
        return builder.toString();
    }

    static {
        Calendar calendar = Calendar.getInstance();
        calendar.set(7000, 0, 1, 0, 0);
        MAX_EXPIRY = calendar.getTimeInMillis();
        BCProviderFactory.getProvider();
    }

    public static class CryptoInfo {
        private KeyPair keyPair;
        private java.security.cert.X509Certificate certificate;

        public CryptoInfo(KeyPair keyPair, java.security.cert.X509Certificate certificate) {
            this.keyPair = keyPair;
            this.certificate = certificate;
        }

        public KeyPair getKeyPair() {
            return this.keyPair;
        }

        public void setKeyPair(KeyPair keyPair) {
            this.keyPair = keyPair;
        }

        public java.security.cert.X509Certificate getCertificate() {
            return this.certificate;
        }

        public void setCertificate(java.security.cert.X509Certificate certificate) {
            this.certificate = certificate;
        }
    }
}

