/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.security.masterkey;

import java.io.File;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jfrog.security.common.KeyUtils;
import org.jfrog.security.crypto.EncryptionWrapper;
import org.jfrog.security.crypto.EncryptionWrapperFactory;
import org.jfrog.security.masterkey.MasterKeyStorage;
import org.jfrog.security.masterkey.exception.MasterKeyStorageException;
import org.jfrog.security.masterkey.status.MasterKeyStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MasterKeyBootstrapper {
    protected static final Logger log = LoggerFactory.getLogger(MasterKeyBootstrapper.class);
    protected static final long DEFAULT_WAIT_FOR_KEY_TIMEOUT = 60000L;
    protected MasterKeyStorage masterKeyService;

    protected void handleMasterKey() {
        log.debug("Searching for Master key under home directory.");
        EncryptionWrapper masterKeyWrapper = this.getLocalMasterKeyWrapper();
        log.debug("Master key found.");
        MasterKeyStatus keyStatus = this.getKeyDetails(masterKeyWrapper);
        if (this.validateOrInsertKeyIfNeeded(keyStatus)) {
            log.debug("Key validation/insertion succeeded.");
            File masterKeyFile = this.getMasterKeyFile();
            this.saveAndSecureMasterKey(masterKeyWrapper, masterKeyFile);
            this.setMasterKeyEncryptionWrapper(masterKeyWrapper);
        }
    }

    private EncryptionWrapper getLocalMasterKeyWrapper() {
        EncryptionWrapper masterEncryptionWrapper = null;
        File localMasterKeyFile = this.getMasterKeyFile();
        try {
            String keyText = System.getProperty("jfrog.master.key");
            if (StringUtils.isNotBlank((String)keyText)) {
                log.info("Got jfrog.master.key system param, using it as master.key");
                masterEncryptionWrapper = EncryptionWrapperFactory.aesKeyWrapperFromString(keyText);
            } else if (localMasterKeyFile.exists()) {
                log.info("Found master.key file at {}, using it as master.key", (Object)localMasterKeyFile.getAbsolutePath());
                masterEncryptionWrapper = EncryptionWrapperFactory.aesKeyWrapperFromFile(localMasterKeyFile);
            }
            if (masterEncryptionWrapper == null) {
                log.info("No master.key was supplied (system prop or file), attempting to generate new master.key");
                masterEncryptionWrapper = this.generateNewMasterKey();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return masterEncryptionWrapper;
    }

    private MasterKeyStatus getKeyDetails(EncryptionWrapper masterKeyWrapper) {
        String serviceName = this.getServiceName();
        return new MasterKeyStatus(masterKeyWrapper.getFingerprint(), MasterKeyStatus.MasterKeyStatusEnum.on, serviceName, 0L);
    }

    private boolean validateOrInsertKeyIfNeeded(@Nonnull MasterKeyStatus fsKeyDetails) {
        MasterKeyStatus dbKeyInfo = this.masterKeyService.getMasterKeyInfo();
        boolean shouldVerifyAgainstDb = false;
        if (dbKeyInfo == null) {
            try {
                log.debug("Attempting to insert key fingerprint into the DB.");
                this.masterKeyService.insertMasterKey(fsKeyDetails);
            }
            catch (MasterKeyStorageException e) {
                log.debug("Could not insert key fingerprint into the DB.", (Throwable)e);
                shouldVerifyAgainstDb = true;
            }
        } else {
            log.debug("DB already has master key associated.");
            shouldVerifyAgainstDb = true;
        }
        return !shouldVerifyAgainstDb || this.verifyKeyAgainstDb(fsKeyDetails);
    }

    private boolean verifyKeyAgainstDb(MasterKeyStatus fsKeyDetails) {
        log.trace("Validating master key against the DB.");
        boolean sameKey = this.masterKeyService.isKeyExists(fsKeyDetails.getKid());
        if (!sameKey) {
            File masterKeyFile = this.getMasterKeyFile();
            if (masterKeyFile.exists() || this.masterKeyProvidedByParam()) {
                throw new IllegalStateException("Master key mismatch. The provided master.key file does't match the DB fingerprint. Make sure your db.properties configurations are valid and the master key matches the DB you are trying to connect to.");
            }
            log.warn("Found existing master key fingerprint in the DB, without master.key file. Please provide a master key file manually in '{}'.", (Object)this.getMasterKeyFile().getAbsolutePath());
            log.info("Waiting for 1 minute until the key is supplied manually...");
            KeyUtils.waitForKey(this.getMasterKeyFile(), this.getWaitForKeyTimeoutValue());
            this.handleMasterKey();
            return false;
        }
        return true;
    }

    private void saveAndSecureMasterKey(EncryptionWrapper masterKeyWrapper, File targetKeyFile) {
        boolean keyProvidedByParam = this.masterKeyProvidedByParam();
        if (!targetKeyFile.exists() && !keyProvidedByParam) {
            KeyUtils.saveKeyToFile(targetKeyFile, masterKeyWrapper);
        }
    }

    private boolean masterKeyProvidedByParam() {
        return StringUtils.isNotBlank((String)System.getProperty("jfrog.master.key"));
    }

    protected abstract long getWaitForKeyTimeoutValue();

    protected abstract File getMasterKeyFile();

    protected abstract void setMasterKeyEncryptionWrapper(EncryptionWrapper var1);

    protected abstract EncryptionWrapper generateNewMasterKey();

    protected abstract String getServiceName();
}

