/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.security.joinkey;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.security.common.KeyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JoinKeyBootstrapper {
    private static final Logger log = LoggerFactory.getLogger(JoinKeyBootstrapper.class);
    public static final String JFROG_JOIN_KEY = "jfrog.join.key";
    public static final String JFROG_JOIN_KEY_PATHS = "jfrog.join.key.paths";
    public static final String JFROG_JOIN_KEY_ENV = "jfrog.join.key".toUpperCase().replace('.', '_');
    private String joinKey;

    public String getJoinKey() {
        return this.getJoinKey(true);
    }

    public String getJoinKey(boolean deleteJoinKey) {
        if (this.joinKey == null) {
            try {
                this.joinKey = this.initAndGetJoinKey();
            }
            finally {
                if (deleteJoinKey && this.getJoinKeyFile().exists()) {
                    FileUtils.deleteQuietly((File)this.getJoinKeyFile());
                }
            }
        }
        return this.joinKey;
    }

    private String initAndGetJoinKey() {
        String keyText = System.getProperty(JFROG_JOIN_KEY);
        if (!StringUtils.isBlank((CharSequence)keyText)) {
            log.debug("join key initialized from property");
            return keyText;
        }
        keyText = System.getenv(JFROG_JOIN_KEY_ENV);
        if (!StringUtils.isBlank((CharSequence)keyText)) {
            log.debug("join key initialized from Environment Variable");
            return keyText;
        }
        return this.readJoinKeyFromFile();
    }

    private String readJoinKeyFromFile() {
        File joinKeyFile = this.getJoinKeyFile();
        KeyUtils.waitForKey(joinKeyFile, this.getWaitForKeyTimeoutValue());
        try {
            log.debug("join key initialized from {}", (Object)joinKeyFile);
            return KeyUtils.readKeyFromFile(joinKeyFile);
        }
        catch (IOException e) {
            log.error("Unable to read join key file {}", (Object)joinKeyFile, (Object)e);
            throw new IllegalArgumentException(e);
        }
    }

    protected abstract File getJoinKeyFile();

    protected abstract long getWaitForKeyTimeoutValue();
}

