/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.security.crypto.encrypter;

import javax.annotation.Nonnull;
import org.jfrog.security.crypto.encrypter.BytesEncrypter;
import org.jfrog.security.crypto.encrypter.BytesEncrypterHelper;
import org.jfrog.security.crypto.exception.CryptoException;

public abstract class BytesEncrypterBase
implements BytesEncrypter {
    protected final String fingerprint;
    protected final String keyId;

    public BytesEncrypterBase(byte[] keyData) {
        try {
            this.fingerprint = BytesEncrypterHelper.getFingerprint(keyData);
            this.keyId = BytesEncrypterHelper.keyIdFromFingerPrint(this.fingerprint);
        }
        catch (CryptoException e) {
            throw new RuntimeException("CryptoException ", e);
        }
    }

    @Override
    @Nonnull
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Override
    @Nonnull
    public String getKeyId() {
        return this.keyId;
    }

    public boolean keyMatch(String keyId) {
        return this.getKeyId().equals(keyId);
    }

    public String toString() {
        return "BytesEncrypterBase{ Cipher='" + (Object)((Object)this.getCipherAlg()) + '\'' + ",  keyId='" + this.keyId + '\'' + '}';
    }
}

