/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.security.crypto;

import java.io.File;
import java.io.FileFilter;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.ArrayList;
import javax.crypto.SecretKey;
import org.jfrog.security.crypto.AsymKeyBytesEncrypter;
import org.jfrog.security.crypto.CipherAlg;
import org.jfrog.security.crypto.DecodedKeyPair;
import org.jfrog.security.crypto.EncodedKeyPair;
import org.jfrog.security.crypto.EncodingType;
import org.jfrog.security.crypto.EncryptionWrapper;
import org.jfrog.security.crypto.EncryptionWrapperBase;
import org.jfrog.security.crypto.FormatUsed;
import org.jfrog.security.crypto.JFrogCryptoHelper;
import org.jfrog.security.crypto.JFrogEnvelop;
import org.jfrog.security.crypto.KeyTool;
import org.jfrog.security.crypto.encrypter.AesBytesEncrypter;
import org.jfrog.security.crypto.encrypter.BytesEncrypterBase;
import org.jfrog.security.crypto.encrypter.BytesEncrypterHelper;
import org.jfrog.security.crypto.encrypter.DESedeBytesEncrypter;
import org.jfrog.security.crypto.result.DecryptionStatusHolder;
import org.jfrog.security.file.SecurityFolderHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EncryptionWrapperFactory {
    private static final Logger log = LoggerFactory.getLogger(EncryptionWrapperFactory.class);

    public static EncryptionWrapper createArtifactoryKeyWrapper(File masterKeyFile, File masterKeyChainDir, int numOfOldKeys, FileFilter keyFileFilter) {
        EncryptionWrapper res = EncryptionWrapperFactory.createMultiKeyFileWrapper(masterKeyFile, masterKeyChainDir, numOfOldKeys, keyFileFilter);
        log.info("createArtifactoryKeyWrapper  {}", (Object)res);
        return res;
    }

    public static EncryptionWrapper aesKeyWrapperFromFile(File keyFile) {
        SecretKey secretKey = JFrogCryptoHelper.loadAesKeyFromFile(keyFile);
        return EncryptionWrapperFactory.getMasterKeyEncryptionWrapper(secretKey);
    }

    private static EncryptionWrapper getMasterKeyEncryptionWrapper(SecretKey secretKey) {
        return new EncryptionWrapperBase(EncodingType.MASTER_LEVEL, new AesBytesEncrypter(secretKey), null, FormatUsed.OldFormat);
    }

    public static EncryptionWrapper aesKeyWrapperFromString(String key) {
        SecretKey secretKey = JFrogCryptoHelper.aesFromString(key);
        return EncryptionWrapperFactory.getMasterKeyEncryptionWrapper(secretKey);
    }

    public static EncryptionWrapper createAesKeyFile() {
        SecretKey secretKey = JFrogCryptoHelper.generateAesKey();
        return EncryptionWrapperFactory.getMasterKeyEncryptionWrapper(secretKey);
    }

    public static EncryptionWrapper createKeyWrapper(EncodingType encodingType, String symmetricKeyPass) {
        if (EncodingType.MASTER_LEVEL.equals((Object)encodingType) || EncodingType.JFROG_AES_256.equals((Object)encodingType)) {
            SecretKey aesKey = JFrogCryptoHelper.generateAesKeyUsingPbe(symmetricKeyPass, null);
            return new EncryptionWrapperBase(encodingType, new AesBytesEncrypter(aesKey), null, FormatUsed.OldFormat);
        }
        SecretKey secretKey = JFrogCryptoHelper.generatePbeKey(symmetricKeyPass);
        return new EncryptionWrapperBase(encodingType, new DESedeBytesEncrypter(secretKey), null, FormatUsed.OldFormat);
    }

    public static EncryptionWrapper createKeyWrapper(EncryptionWrapper masterWrapper, EncodingType encodingType, EncodedKeyPair encodedKeyPair) {
        KeyPair keyPair = encodedKeyPair.decode(masterWrapper, new DecryptionStatusHolder()).createKeyPair();
        if (EncodingType.MASTER_LEVEL.equals((Object)encodingType) || EncodingType.JFROG_AES_256.equals((Object)encodingType)) {
            BytesEncrypterBase aesEncrypter = BytesEncrypterHelper.getAESEncrypterCreateSecret(keyPair);
            return new EncryptionWrapperBase(encodingType, aesEncrypter, null, FormatUsed.OldFormat);
        }
        BytesEncrypterBase desedeEncrypter = BytesEncrypterHelper.getDesedeEncrypterCreateSecret(keyPair);
        ArrayList<BytesEncrypterBase> decrypters = new ArrayList<BytesEncrypterBase>();
        return new EncryptionWrapperBase(encodingType, desedeEncrypter, decrypters, FormatUsed.OldFormat);
    }

    public static EncryptionWrapper createKeyWrapper(EncryptionWrapper masterWrapper, EncodedKeyPair encodedKeyPair) {
        return EncryptionWrapperFactory.createKeyWrapper(masterWrapper, EncodingType.ARTIFACTORY_PASSWORD, encodedKeyPair);
    }

    public static EncryptionWrapper createKeyWrapper(DecodedKeyPair decodedKeyPair) {
        BytesEncrypterBase desedeEncrypter = BytesEncrypterHelper.getDesedeEncrypterCreateSecret(decodedKeyPair.createKeyPair());
        return new EncryptionWrapperBase(EncodingType.ARTIFACTORY_PASSWORD, desedeEncrypter, null, FormatUsed.OldFormat);
    }

    public static void ensureMatchingPrivatePublicKeys(KeyPair keyPair) {
        EncodedKeyPair encodedKeyPair = JFrogCryptoHelper.encodeKeyPair(keyPair);
        EncryptionWrapperBase asymKeyWrapper = EncryptionWrapperFactory.createAsymKeyWrapper(encodedKeyPair);
        asymKeyWrapper.ensureMatchingPrivatePublicKeys();
    }

    static EncryptionWrapper createMultiKeyFileWrapper(File currentMasterKeyFile, File masterKeyChainDir, int numOfOldKeys, FileFilter keyFileFilter) {
        KeyTool keyTool = new KeyTool(currentMasterKeyFile, masterKeyChainDir, numOfOldKeys, keyFileFilter);
        return EncryptionWrapperFactory.createMultiKeyFileEncryptionWrapper(EncodingType.ARTIFACTORY_MASTER, keyTool);
    }

    private static EncryptionWrapperBase createAsymKeyWrapper(EncodedKeyPair encodedKeyPair) {
        DecodedKeyPair decodedKeyPair = encodedKeyPair.decode(null, new DecryptionStatusHolder());
        if (encodedKeyPair.hasPrivateKey()) {
            KeyPair keyPair = decodedKeyPair.createKeyPair();
            AsymKeyBytesEncrypter encrypter = new AsymKeyBytesEncrypter(keyPair.getPublic(), keyPair.getPrivate());
            return new EncryptionWrapperBase(EncodingType.JFROG_TOKEN, encrypter, null, FormatUsed.OldFormat);
        }
        PublicKey publicKey = decodedKeyPair.createPublicKey();
        AsymKeyBytesEncrypter encrypter = new AsymKeyBytesEncrypter(publicKey, null);
        return new EncryptionWrapperBase(EncodingType.JFROG_TOKEN, encrypter, null, FormatUsed.OldFormat);
    }

    private static EncryptionWrapperBase createMultiKeyFileEncryptionWrapper(EncodingType targetEncodingType, KeyTool keyTool) {
        BytesEncrypterBase topEncryptor = EncryptionWrapperFactory.createTopEncryptor(keyTool);
        FormatUsed useFormat = FormatUsed.DotFormat;
        if (CipherAlg.DESede.equals((Object)topEncryptor.getCipherAlg())) {
            useFormat = FormatUsed.OldFormat;
        }
        return new EncryptionWrapperBase(targetEncodingType, topEncryptor, BytesEncrypterHelper.buildFallbackBytesEncryptersList(keyTool.getKeyFiles()), useFormat);
    }

    private static BytesEncrypterBase createTopEncryptor(KeyTool keyTool) {
        BytesEncrypterBase topEncrypter;
        JFrogEnvelop topKey = keyTool.getTopKey();
        if (EncodingType.SYMMETRIC_KEY.equals((Object)topKey.encodingType)) {
            topEncrypter = BytesEncrypterHelper.getBytesEncrypterForSymKey(topKey);
        } else {
            KeyPair keyPair = SecurityFolderHelper.getKeyPairFromFile(keyTool.currentMasterKeyFile);
            topEncrypter = BytesEncrypterHelper.getDesedeBytesEncrypterForKeyPair(keyPair);
        }
        return topEncrypter;
    }

    static EncryptionWrapper createMissionControlMasterWrapper(File masterKeyFile, File masterKeyChainDir, FileFilter keyFileFilter) {
        KeyTool keyTool = new KeyTool(masterKeyFile, masterKeyChainDir, 0, keyFileFilter);
        return EncryptionWrapperFactory.createMultiKeyFileEncryptionWrapper(EncodingType.JFMC_MASTER, keyTool);
    }

    static EncryptionWrapper createMultiKeyFileWrapperForTest(File currentMasterKeyFile, File masterKeyChainDir, FileFilter keyFileFilter) {
        KeyTool keyTool = new KeyTool(currentMasterKeyFile, masterKeyChainDir, 0, keyFileFilter);
        return EncryptionWrapperFactory.createMultiKeyFileEncryptionWrapper(EncodingType.ARTIFACTORY_MASTER, keyTool);
    }
}

